#ifndef ABAKUS_MAINWINDOW_H
#define ABAKUS_MAINWINDOW_H
/*
 * mainwindow.h - part of abakus
 * Copyright (C) 2004, 2005 Michael Pyne <michael.pyne@kdemail.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <kmainwindow.h>

#include "numerictypes.h"

class TQPoint;
class TQVBox;
class TQCheckBox;
class TQRadioButton;
class TQBoxLayout;
class TQListViewItem;
class TQSplitter;
class TQTimer;

//class KComboBox;
class Editor;
class KPopupMenu;
class KAction;
class KListView;
class ResultListView;
class ResultListViewText;

class AbakusIface;

// Main window class, handles events and layout and stuff
class MainWindow : public KMainWindow
{
    Q_OBJECT
  TQ_OBJECT
    public:
    MainWindow();

    bool inRPNMode() const;

    protected:
    virtual void contextMenuEvent(TQContextMenuEvent *e);
    virtual bool eventFilter(TQObject *o, TQEvent *e);
    virtual bool queryExit();
    virtual void polish();

    private slots:
    void slotReturnPressed();
    void slotTextChanged();
    void slotEvaluate();

    void slotPrecisionAuto();
    void slotPrecision3();
    void slotPrecision8();
    void slotPrecision15();
    void slotPrecision50();
    void slotPrecisionCustom();

    void slotUpdateSize();

    void slotDegrees();
    void slotRadians();

    void slotEntrySelected(const TQString &text);
    void slotResultSelected(const TQString &text);

    void slotToggleMenuBar();
    void slotToggleFunctionList();
    void slotToggleVariableList();
    void slotToggleHistoryList();
    void slotToggleCompactMode();
    void slotToggleExpressionMode();

    void slotNewValue(const TQString &name, Abakus::number_t value);
    void slotChangeValue(const TQString &name, Abakus::number_t value);
    void slotRemoveValue(const TQString &name);

    void slotNewFunction(const TQString &name);
    void slotRemoveFunction(const TQString &name);

    private:
    int getParenthesesLevel(const TQString &str);

    void redrawResults();
    void selectCorrectPrecisionAction();

    void loadConfig();
    void saveConfig();
    void setupLayout();
    void populateListViews();
    TQString interpolateExpression(const TQString &text, ResultListViewText *after);

    // Donated via JuK
    KAction *action(const char *key) const;

    template <class T> T *action(const char *key) const
    {
	return dynamic_cast<T *>(action(key));
    }

    private:
    TQVBox *m_history;
    TQRadioButton *m_degrees;
    TQRadioButton *m_radians;
    Editor *m_edit;
    KPopupMenu *m_popup;
    ResultListView *m_result;
    TQString m_lastError;
    TQBoxLayout *m_layout;
    KListView *m_fnList, *m_varList;
    TQSplitter *m_mainSplitter, *m_listSplitter;
    TQSize m_newSize, m_oldSize;

    AbakusIface *m_dcopInterface;

    bool m_wasFnShown, m_wasVarShown, m_wasHistoryShown;
    bool m_compactMode;

    bool m_insert;
};

#endif
