/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "xsltexporter.h"
#include "xslthandler.h"
#include "tellicoxmlexporter.h"
#include "../filehandler.h"

#include <klocale.h>
#include <kurlrequester.h>

#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqdom.h>
#include <tqwhatsthis.h>

using Tellico::Export::XSLTExporter;

XSLTExporter::XSLTExporter() : Export::Exporter(),
    m_widget(0),
    m_URLRequester(0) {
}

TQString XSLTExporter::formatString() const {
  return i18n("XSLT");
}

TQString XSLTExporter::fileFilter() const {
  return i18n("*|All Files");
}


bool XSLTExporter::exec() {
  KURL u = m_URLRequester->url();
  if(u.isEmpty() || !u.isValid()) {
    return TQString();
  }
  //  XSLTHandler handler(FileHandler::readXMLFile(url));
  XSLTHandler handler(u);

  TellicoXMLExporter exporter;
  exporter.setEntries(entries());
  exporter.setOptions(options());
  TQDomDocument dom = exporter.exportXML();
  return FileHandler::writeTextURL(url(), handler.applyStylesheet(dom.toString()),
                                   options() & ExportUTF8, options() & Export::ExportForce);
}

TQWidget* XSLTExporter::widget(TQWidget* parent_, const char* name_/*=0*/) {
  if(m_widget && TQT_BASE_OBJECT(m_widget->parent()) == TQT_BASE_OBJECT(parent_)) {
    return m_widget;
  }

  m_widget = new TQWidget(parent_, name_);
  TQVBoxLayout* l = new TQVBoxLayout(m_widget);

  TQGroupBox* group = new TQGroupBox(1, Qt::Horizontal, i18n("XSLT Options"), m_widget);
  l->addWidget(group);

  TQHBox* box = new TQHBox(group);
  box->setSpacing(4);
  (void) new TQLabel(i18n("XSLT file:"), box);
  m_URLRequester = new KURLRequester(box);
  TQWhatsThis::add(m_URLRequester, i18n("Choose the XSLT file used to transform the Tellico XML data."));

  l->addStretch(1);
  return m_widget;
}
