/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef PILOTDBEXPORTER_H
#define PILOTDBEXPORTER_H

class TQCheckBox;

#include "exporter.h"

#include <tqstringlist.h>

namespace Tellico {
  namespace Export {

/**
 * @author Robby Stephenson
 */
class PilotDBExporter : public Exporter {
Q_OBJECT
  TQ_OBJECT

public:
  PilotDBExporter();

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  virtual TQWidget* widget(TQWidget* parent, const char* name=0);
  virtual void readOptions(KConfig* cfg);
  virtual void saveOptions(KConfig* cfg);

  void setColumns(const TQStringList& columns) { m_columns = columns; }

private:
  bool m_backup;

  TQWidget* m_widget;
  TQCheckBox* m_checkBackup;
  TQStringList m_columns;
};

  } // end namespace
} // end namespace
#endif
