/***************************************************************************
    copyright            : (C) 2007 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "deliciousimporter.h"
#include "../collection.h"
#include "../rtf2html/rtf2html.h"
#include "../imagefactory.h"
#include "../tellico_debug.h"

#include <kstandarddirs.h>

#include <tqfile.h>

using Tellico::Import::DeliciousImporter;

DeliciousImporter::DeliciousImporter(const KURL& url_) : XSLTImporter(url_) {
  TQString xsltFile = locate("appdata", TQString::fromLatin1("delicious2tellico.xsl"));
  if(!xsltFile.isEmpty()) {
    KURL u;
    u.setPath(xsltFile);
    XSLTImporter::setXSLTURL(u);
  } else {
    kdWarning() << "DeliciousImporter() - unable to find delicious2tellico.xml!" << endl;
  }
}

bool DeliciousImporter::canImport(int type) const {
  return type == Data::Collection::Book;
}

Tellico::Data::CollPtr DeliciousImporter::collection() {
  Data::CollPtr coll = XSLTImporter::collection();
  if(!coll) {
    return 0;
  }

  KURL libraryDir = url();
  libraryDir.setPath(url().directory() + "Images/");
  const TQStringList imageDirs = TQStringList()
                              << TQString::fromLatin1("Large Covers/")
                              << TQString::fromLatin1("Medium Covers/")
                              << TQString::fromLatin1("Small Covers/")
                              << TQString::fromLatin1("Plain Covers/");
  const TQString commField = TQString::fromLatin1("comments");
  const TQString uuidField = TQString::fromLatin1("uuid");
  const TQString coverField = TQString::fromLatin1("cover");
  const bool isLocal = url().isLocalFile();

  Data::EntryVec entries = coll->entries();
  for(Data::EntryVecIt entry = entries.begin(); entry != entries.end(); ++entry) {
    TQString comments = entry->field(commField);
    if(!comments.isEmpty()) {
      RTF2HTML rtf2html(comments);
      entry->setField(commField, rtf2html.toHTML());
    }

    //try to add images
    TQString uuid = entry->field(uuidField);
    if(!uuid.isEmpty() && isLocal) {
      for(TQStringList::ConstIterator it = imageDirs.begin(); it != imageDirs.end(); ++it) {
        TQString imgPath = libraryDir.path() + *it + uuid;
        if(!TQFile::exists(imgPath)) {
          continue;
        }
        TQString imgID = ImageFactory::addImage(imgPath, true);
        if(!imgID.isEmpty()) {
          entry->setField(coverField, imgID);
        }
        break;
      }
    }
  }
  coll->removeField(uuidField);
  return coll;
}

#include "deliciousimporter.moc"
