/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef BIBTEXIMPORTER_H
#define BIBTEXIMPORTER_H

#include <config.h>
#include "importer.h"
#include "../datavectors.h"

extern "C" {
#ifdef HAVE_LIBBTPARSE
#include <btparse.h>
#else
#include "btparse/btparse.h"
}
#endif

#include <tqptrlist.h>
#include <tqmap.h>

class TQRadioButton;

namespace Tellico {
  namespace Import {

/**
 * Bibtex files are used for bibliographies within LaTex. The btparse library is used to
 * parse the text and generate a @ref BibtexCollection.
 *
 * @author Robby Stephenson
 */
class BibtexImporter : public Importer {
Q_OBJECT
  TQ_OBJECT

public:
  /**
   * Initializes the btparse library
   *
   * @param url The url of the bibtex file
   */
  BibtexImporter(const KURL::List& urls);
  BibtexImporter(const TQString& text);
  /*
   * Some cleanup is done for the btparse library
   */
  virtual ~BibtexImporter();

  /**
   * Returns a pointer to a @ref BibtexCollection created on the stack. All entries
   * in the bibtex file are added, including any preamble, all macro strings, and each entry.
   *
   * @return A pointer to a @ref BibtexCollection, or 0 if none can be created.
   */
  virtual Data::CollPtr collection();
  virtual TQWidget* widget(TQWidget* parent, const char* name=0);
  virtual bool canImport(int type) const;

public slots:
  void slotCancel();

private:
  Data::CollPtr readCollection(const TQString& text, int n);
  void parseText(const TQString& text);

  typedef TQPtrList<AST> ASTList;
  typedef TQPtrListIterator<AST> ASTListIterator;
  ASTList m_nodes;
  TQMap<TQString, TQString> m_macros;

  Data::CollPtr m_coll;
  TQWidget* m_widget;
  TQRadioButton* m_readUTF8;
  TQRadioButton* m_readLocale;
  bool m_cancelled : 1;
};

  } // end namespace
} // end namespace
#endif
