/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef RATINGWIDGET_H
#define RATINGWIDGET_H

#include "../datavectors.h"

#include <tqhbox.h>
#include <tqptrlist.h>
#include <tqlabel.h>
#include <tqpixmap.h>

namespace Tellico {
  namespace Data {
    class Field;
  }
  namespace GUI {

/**
 * @author Robby Stephenson
 */
class RatingWidget : public TQHBox {
Q_OBJECT
  TQ_OBJECT

typedef TQPtrList<TQLabel> LabelList;

public:
  RatingWidget(Data::FieldPtr field, TQWidget* parent, const char* name = 0);

  void clear();
  TQString text() const;
  void setText(const TQString& text);
  void updateField(Data::FieldPtr field);

  static const TQPixmap& pixmap(const TQString& value);

public slots:
  void update();

signals:
  void modified();

protected:
  virtual void mousePressEvent(TQMouseEvent* e);

private:
  void init();
  void updateBounds();

  Data::ConstFieldPtr m_field;
  LabelList m_widgets;

  int m_currIndex;
  int m_total;
  int m_min;
  int m_max;

  TQPixmap m_pixOn;
  TQPixmap m_pixOff;
};

  } // end GUI namespace
} // end namespace
#endif
