/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef FIELDWIDGET_H
#define FIELDWIDGET_H

#include "../datavectors.h"

#include <tqwidget.h>
#include <tqregexp.h>

class TQLabel;
class TQCheckBox;
class TQString;

namespace Tellico {
  namespace Data {
    class Field;
  }
  namespace GUI {

/**
 * The FieldWidget class is a box that shows a label, then a widget which depends
 * on the field type, and then a checkbox for multiple editing.
 *
 * @author Robby Stephenson
 */
class FieldWidget : public TQWidget {
Q_OBJECT
  TQ_OBJECT

public:
  FieldWidget(Data::FieldPtr field, TQWidget* parent, const char* name=0);
  virtual ~FieldWidget() {}

  Data::FieldPtr field() const { return m_field; }
  virtual TQString text() const = 0;
  virtual void setText(const TQString& text) = 0;

  int labelWidth() const;
  void setLabelWidth(int width);
  bool isEnabled();
  bool expands() const;
  void editMultiple(bool show);
  // calls updateFieldHook()
  void updateField(Data::FieldPtr oldField, Data::FieldPtr newField);

  // only used by LineFieldWidget, really
  virtual void addCompletionObjectItem(const TQString&) {}

  // factory function
  static FieldWidget* create(Data::FieldPtr field, TQWidget* parent, const char* name=0);

public slots:
  virtual void insertDefault();
  virtual void clear() = 0;
  void setEnabled(bool enabled);

signals:
  virtual void modified();

protected:
  TQLabel* label() { return m_label; } // needed so the URLField can handle clicks on the label
  virtual TQWidget* widget() = 0;
  void registerWidget();

  // not all widgets have to be updated when the field changes
  virtual void updateFieldHook(Data::FieldPtr, Data::FieldPtr) {}

  static const TQRegExp s_semiColon;

private:
  Data::FieldPtr m_field;
  TQLabel* m_label;
  TQCheckBox* m_editMultiple;

  bool m_expands;
};

  } // end GUI namespace
} // end namespace
#endif
