/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "counteditem.h"
#include "../tellico_utils.h"
#include "../tellico_debug.h"

#include <kglobalsettings.h>
#include <kstringhandler.h>

#include <tqpainter.h>
#include <tqpixmap.h>

using Tellico::GUI::CountedItem;

int CountedItem::compare(TQListViewItem* item_, int col_, bool asc_) const {
  GUI::ListView* lv = listView();
  GUI::CountedItem* item = static_cast<GUI::CountedItem*>(item_);
  if(lv->sortStyle() == GUI::ListView::SortByCount) {
    if(count() < item->count()) {
      return -1;
    } else if(count() > item->count()) {
      return 1;
    } else {
      return GUI::ListViewItem::compare(item, col_, asc_);
    }
  }
  // for now, only other style is by text
  return GUI::ListViewItem::compare(item, col_, asc_);
}

void CountedItem::paintCell(TQPainter* p_, const TQColorGroup& cg_,
                            int column_, int width_, int align_) {
  if(!p_) {
    return;
  }

  // always paint the cell

  // show count is only for first column
  if(column_ != 0) {
    ListViewItem::paintCell(p_, cg_, column_, width_, align_);
    return;
  }

  // set a catchable text so that we can have our own implementation (see further down)
  // but still benefit from KListView::paintCell
  TQString oldText = text(column_);
//  if(oldText.isEmpty()) {
  if(oldText == '\t') {
    return; // avoid endless loop!
  }

  setText(column_, TQChar('\t'));
  ListViewItem::paintCell(p_, cg_, column_, width_, align_);
  setText(column_, oldText);

  int marg = listView()->itemMargin();
  int r = marg;
  const TQPixmap* icon = pixmap(column_);
  if(icon) {
    r += icon->width() + marg;
  }

  TQFontMetrics fm = p_->fontMetrics();
  TQString numText = TQString::fromLatin1(" (%1)").arg(count());
  // don't call CountedListViewItem::width() because that includes the count already
  int w = ListViewItem::width(fm, listView(), column_);
  int countWidth = fm.width(numText);
  if(w+marg+r+countWidth > width_) {
    oldText = KStringHandler::rPixelSqueeze(oldText, fm, width_-marg-r-countWidth);
  }
  if(isSelected()) {
    p_->setPen(cg_.highlightedText());
  } else {
    p_->setPen(cg_.text());
  }
  TQRect br(0, height(), r, 0);
  if(!oldText.isEmpty() && !oldText.startsWith(TQChar('\t'))) {
    p_->drawText(r, 0, width_-marg-r, height(), align_ | AlignVCenter, oldText, -1, &br);
  }

  if(isSelected()) {
    p_->setPen(cg_.highlightedText());
  } else {
    if(!Tellico::contrastColor.isValid()) {
      updateContrastColor(cg_);
    }
    p_->setPen(Tellico::contrastColor);
  }
  p_->drawText(br.right(), 0, width_-marg-br.right(), height(), align_ | TQt::AlignVCenter, numText);
}

int CountedItem::width(const TQFontMetrics& fm_, const TQListView* lv_, int column_) const {
  int w = ListViewItem::width(fm_, lv_, column_);

  // show count is only for first column
  if(column_ == 0) {
    TQString numText = TQString::fromLatin1(" (%1)").arg(count());
    w += fm_.width(numText) + 2; // add a little pad
  }
  return w;
}
