/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef BOOLFIELDWIDGET_H
#define BOOLFIELDWIDGET_H

#include "fieldwidget.h"
#include "../datavectors.h"

class TQCheckBox;
class TQString;

namespace Tellico {
  namespace GUI {

/**
 * @author Robby Stephenson
 */
class BoolFieldWidget : public FieldWidget {
Q_OBJECT
  TQ_OBJECT

public:
  BoolFieldWidget(Data::FieldPtr field, TQWidget* parent, const char* name=0);
  virtual ~BoolFieldWidget() {}

  virtual TQString text() const;
  virtual void setText(const TQString& text);

public slots:
  virtual void clear();

protected:
  virtual TQWidget* widget();

private:
  TQCheckBox* m_checkBox;
};

  } // end GUI namespace
} // end namespace
#endif
