/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCHERCONFIGDIALOG_H
#define TELLICO_FETCHERCONFIGDIALOG_H

#include "fetch/fetch.h"
#include "fetch/configwidget.h"

#include <kdialogbase.h>

#include <tqintdict.h>

class KLineEdit;
class TQCheckBox;
class TQWidgetStack;

namespace Tellico {
  namespace GUI {
    class ComboBox;
  }

/**
 * @author Robby Stephenson
 */
class FetcherConfigDialog : public KDialogBase {
Q_OBJECT
  TQ_OBJECT

public:
  FetcherConfigDialog(TQWidget* parent);
  FetcherConfigDialog(const TQString& sourceName, Fetch::Type type, bool updateOverwrite,
                      Fetch::ConfigWidget* configWidget, TQWidget* parent);

  TQString sourceName() const;
  Fetch::Type sourceType() const;
  bool updateOverwrite() const;
  Fetch::ConfigWidget* configWidget() const;

private slots:
  void slotNewSourceSelected(int idx);
  void slotNameChanged(const TQString& name);
  void slotPossibleNewName(const TQString& name);

private:
  void init(Fetch::Type type);

  bool m_newSource : 1;
  bool m_useDefaultName : 1;
  Fetch::ConfigWidget* m_configWidget;
  TQLabel* m_iconLabel;
  KLineEdit* m_nameEdit;
  GUI::ComboBox* m_typeCombo;
  TQCheckBox* m_cbOverwrite;
  TQWidgetStack* m_stack;
  TQIntDict<Fetch::ConfigWidget> m_configWidgets;
};

} // end namespace
#endif
