/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCH_ISBNDBFETCHER_H
#define TELLICO_FETCH_ISBNDBFETCHER_H

namespace Tellico {
  class XSLTHandler;
}

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <kio/job.h>

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace Tellico {
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class ISBNdbFetcher : public Fetcher {
Q_OBJECT
  TQ_OBJECT

public:
  ISBNdbFetcher(TQObject* parent = 0, const char* name = 0);
  ~ISBNdbFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person || k == Keyword || k == ISBN; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return ISBNdb; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const KConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const ISBNdbFetcher* fetcher = 0);
    virtual void saveConfig(KConfigGroup&) {}
    virtual TQString preferredName() const;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(KIO::Job* job, const TQByteArray& data);
  void slotComplete(KIO::Job* job);

private:
  void initXSLTHandler();
  void doSearch();

  XSLTHandler* m_xsltHandler;
  int m_limit;
  int m_page;
  int m_total;
  int m_numResults;
  int m_countOffset;

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries;
  TQGuardedPtr<KIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;
};

  }
}
#endif
