/***************************************************************************
    copyright            : (C) 2008 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef DISCOGSFETCHER_H
#define DISCOGSFETCHER_H

namespace Tellico {
  class XSLTHandler;
}

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"
#include <klineedit.h>

#include <tqdom.h>
#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace KIO {
  class Job;
}

namespace Tellico {
  namespace Fetch {

/**
 * A fetcher for discogs.com
 *
 * @author Robby Stephenson
 */
class DiscogsFetcher : public Fetcher {
Q_OBJECT
  TQ_OBJECT

public:
  /**
   */
  DiscogsFetcher(TQObject* parent, const char* name = 0);
  /**
   */
  virtual ~DiscogsFetcher();

  /**
   */
  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();
  // amazon can search title or person
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person || k == Keyword; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return Discogs; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const KConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  /**
   * Returns a widget for modifying the fetcher's config.
   */
  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  static StringMap customFields();

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const DiscogsFetcher* fetcher = 0);
    virtual void saveConfig(KConfigGroup&);
    virtual TQString preferredName() const;
  private:
    KLineEdit *m_apiKeyEdit;
    TQCheckBox* m_fetchImageCheck;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(KIO::Job* job, const TQByteArray& data);
  void slotComplete(KIO::Job* job);

private:
  void initXSLTHandler();
  void doSearch();

  XSLTHandler* m_xsltHandler;
  int m_limit;
  int m_start;
  int m_total;

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries;
  TQGuardedPtr<KIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;

  bool m_fetchImages;
  TQString m_apiKey;
  TQStringList m_fields;
};

  } // end namespace
} // end namespace
#endif
