
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_DEVICEMANAGERDIALOG_H_
#define _RG_DEVICEMANAGERDIALOG_H_

#include "base/Device.h"
#include <kmainwindow.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <vector>


class TQWidget;
class TQTable;
class TQPushButton;
class TQCloseEvent;


namespace Rosegarden
{

class Studio;
class RosegardenGUIDoc;
class MidiDevice;


class DeviceManagerDialog : public KMainWindow
{
    Q_OBJECT
  TQ_OBJECT
public:
    DeviceManagerDialog(TQWidget *parent, RosegardenGUIDoc *document);
    ~DeviceManagerDialog();

    void setModified(bool value);

signals:
    void deviceNamesChanged();

    void editBanks(DeviceId);
    void editControllers(DeviceId);

    void closing();

protected slots:
    void slotClose();
    void slotAddPlayDevice();
    void slotAddRecordDevice();
    void slotDeletePlayDevice();
    void slotDeleteRecordDevice();
    void slotPlayValueChanged(int row, int col);
    void slotRecordValueChanged(int row, int col);
    void slotPlayDeviceSelected(int row, int col);
    void slotRecordDeviceSelected(int row, int col);

    // for play devices only:
    void slotImport();
    void slotExport();
    void slotSetBanks();
    void slotSetControllers();

    void slotDevicesResyncd();
    void populate();

protected:
    virtual void closeEvent(TQCloseEvent *);

private:
    RosegardenGUIDoc *m_document;
    Studio *m_studio;

    TQPushButton *m_deletePlayButton;
    TQPushButton *m_deleteRecordButton;
    TQPushButton *m_importButton;
    TQPushButton *m_exportButton;
    TQPushButton *m_banksButton;
    TQPushButton *m_controllersButton;

    TQStringList m_playConnections;
    TQStringList m_recordConnections;
    void makeConnectionList(unsigned int direction, TQStringList &list);
    
    TQTable *m_playTable;
    TQTable *m_recordTable;

    typedef std::vector<MidiDevice *> MidiDeviceList;
    MidiDeviceList m_playDevices;
    MidiDeviceList m_recordDevices;

    DeviceId getPlayDeviceIdAt(int row); // NO_DEVICE = not found
    DeviceId getRecordDeviceIdAt(int row); // NO_DEVICE = not found

    TQString m_noConnectionString;
};


}

#endif
