/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "GUIPalette.h"
#include <kapplication.h>

#include "base/Colour.h"
#include "document/ConfigGroups.h"
#include <kconfig.h>
#include <tqcolor.h>


namespace Rosegarden
{

TQColor GUIPalette::getColour(const char* const colourName)
{
    KConfig* config = kapp->config();
    config->setGroup(ColoursConfigGroup);

    TQColor res = getInstance()->m_defaultsMap[colourName];
    config->readColorEntry(colourName, &res);
    return res;
}

Colour GUIPalette::convertColour(const TQColor &input)
{
    int r, g, b;
    input.rgb(&r, &g, &b);
    return Colour(r, g, b);
}

TQColor GUIPalette::convertColour(const Colour& input)
{
    return TQColor(input.getRed(), input.getGreen(), input.getBlue());
}

GUIPalette::GUIPalette()
{
    m_defaultsMap[ActiveRecordTrack] = TQt::red;

    m_defaultsMap[SegmentCanvas] = TQColor(230, 230, 230);
    m_defaultsMap[SegmentBorder] = TQt::black;

    // 1.0 colors
    //    m_defaultsMap[RecordingInternalSegmentBlock] = TQColor(255, 182, 193);
    //    m_defaultsMap[RecordingAudioSegmentBlock] = TQColor(182, 222, 255);

    // MIDI recording preview (pale yellow)
    m_defaultsMap[RecordingInternalSegmentBlock] = TQColor(255, 234, 182);

    // audio recording preview (pale red)
    m_defaultsMap[RecordingAudioSegmentBlock] = TQColor(255, 182, 193);

    m_defaultsMap[RecordingSegmentBorder] = TQt::black;

    m_defaultsMap[RepeatSegmentBorder] = TQColor(130, 133, 170);

    m_defaultsMap[SegmentAudioPreview] = TQColor(39, 71, 22);
    m_defaultsMap[SegmentInternalPreview] = TQt::white;
    m_defaultsMap[SegmentLabel] = TQt::black;
    m_defaultsMap[SegmentSplitLine] = TQt::black;

    m_defaultsMap[MatrixElementBorder] = TQt::black;
    m_defaultsMap[MatrixElementBlock] = TQColor(98, 128, 232);
    m_defaultsMap[MatrixOverlapBlock] = TQt::black;

    m_defaultsMap[LoopRulerBackground] = TQColor(120, 120, 120);
    m_defaultsMap[LoopRulerForeground] = TQt::white;
    m_defaultsMap[LoopHighlight] = TQt::white;

    m_defaultsMap[TempoBase] = TQColor(197, 211, 125);

    //m_defaultsMap[TextRulerBackground] = TQColor(60, 205, 230, TQColor::Hsv);
    //    m_defaultsMap[TextRulerBackground] = TQColor(120, 90, 238, TQColor::Hsv);
    //    m_defaultsMap[TextRulerBackground] = TQColor(210, 220, 140);
    m_defaultsMap[TextRulerBackground] = TQColor(226, 232, 187);
    m_defaultsMap[TextRulerForeground] = TQt::white;

    m_defaultsMap[ChordNameRulerBackground] = TQColor(230, 230, 230);
    m_defaultsMap[ChordNameRulerForeground] = TQt::black;

    m_defaultsMap[RawNoteRulerBackground] = TQColor(240, 240, 240);
    m_defaultsMap[RawNoteRulerForeground] = TQt::black;

    m_defaultsMap[LevelMeterGreen] = TQColor(0, 200, 0);
    m_defaultsMap[LevelMeterOrange] = TQColor(255, 165, 0);
    m_defaultsMap[LevelMeterRed] = TQColor(200, 0, 0);

    //    m_defaultsMap[LevelMeterSolidGreen] = TQColor(0, 140, 0);
    m_defaultsMap[LevelMeterSolidGreen] = TQColor(84, 177, 248); // blue!
    //    m_defaultsMap[LevelMeterSolidOrange] = TQColor(220, 120, 0);
    m_defaultsMap[LevelMeterSolidOrange] = TQColor(255, 225, 0);
    //    m_defaultsMap[LevelMeterSolidRed] = TQColor(255, 50, 50);
    m_defaultsMap[LevelMeterSolidRed] = TQColor(255, 0, 0);

    m_defaultsMap[BarLine] = TQt::black;
    m_defaultsMap[BarLineIncorrect] = TQColor(211, 0, 31);
    m_defaultsMap[BeatLine] = TQColor(100, 100, 100);
    m_defaultsMap[SubBeatLine] = TQColor(212, 212, 212);
    m_defaultsMap[StaffConnectingLine] = TQColor(192, 192, 192);
    m_defaultsMap[StaffConnectingTerminatingLine] = TQColor(128, 128, 128);

    m_defaultsMap[Pointer] = TQt::darkBlue;
    m_defaultsMap[PointerRuler] = TQColor(100, 100, 100);

    m_defaultsMap[InsertCursor] = TQColor(160, 104, 186);
    m_defaultsMap[InsertCursorRuler] = TQColor(160, 136, 170);

    m_defaultsMap[TrackDivider] = TQColor(145, 145, 145);
    //m_defaultsMap[MovementGuide] = TQColor(172, 230, 139);
    m_defaultsMap[MovementGuide] = TQColor(62, 161, 194);
    //m_defaultsMap[MovementGuide] = TQColor(255, 189, 89);
    m_defaultsMap[SelectionRectangle] = TQColor(103, 128, 211);
    m_defaultsMap[SelectedElement] = TQColor(0, 54, 232);

    const int SelectedElementHue = 225;
    const int SelectedElementMinValue = 220;
    const int HighlightedElementHue = 25;
    const int HighlightedElementMinValue = 220;
    const int QuantizedNoteHue = 69;
    const int QuantizedNoteMinValue = 140;
    const int TriggerNoteHue = 4;
    const int TriggerNoteMinValue = 140;
    const int OutRangeNoteHue = 0;
    const int OutRangeNoteMinValue = 200;

    m_defaultsMap[TextAnnotationBackground] = TQColor(255, 255, 180);

    m_defaultsMap[TextLilyPondDirectiveBackground] = TQColor(95, 157, 87);

    m_defaultsMap[AudioCountdownBackground] = TQt::darkGray;
    m_defaultsMap[AudioCountdownForeground] = TQt::red;

//    m_defaultsMap[RotaryFloatBackground] = TQt::cyan;
    m_defaultsMap[RotaryFloatBackground] = TQColor(182, 222, 255);
    m_defaultsMap[RotaryFloatForeground] = TQt::black;

    m_defaultsMap[RotaryPastelBlue] = TQColor(205, 212, 255);
    m_defaultsMap[RotaryPastelRed] = TQColor(255, 168, 169);
    m_defaultsMap[RotaryPastelGreen] = TQColor(231, 255, 223);
    m_defaultsMap[RotaryPastelOrange] = TQColor(255, 233, 208);
    m_defaultsMap[RotaryPastelYellow] = TQColor(249, 255, 208);

    m_defaultsMap[MatrixKeyboardFocus] = TQColor(224, 112, 8);

    //    m_defaultsMap[RotaryPlugin] = TQColor(185, 255, 248);
    m_defaultsMap[RotaryPlugin] = TQColor(185, 200, 248);
    //    m_defaultsMap[RotaryPlugin] = TQColor(185, 185, 185);

    m_defaultsMap[RotaryMeter] = TQColor(255, 100, 0);

    m_defaultsMap[MarkerBackground] = TQColor(185, 255, 248);

    m_defaultsMap[QuickMarker] = TQt::red;

    //    m_defaultsMap[MuteTrackLED] = TQColor(218, 190, 230, TQColor::Hsv);
    m_defaultsMap[MuteTrackLED] = TQColor(211, 194, 238, TQColor::Hsv);
    m_defaultsMap[RecordMIDITrackLED] = TQColor(45, 250, 225, TQColor::Hsv);
    m_defaultsMap[RecordAudioTrackLED] = TQColor(0, 250, 225, TQColor::Hsv);

    m_defaultsMap[PlaybackFaderOutline] = TQColor(211, 194, 238, TQColor::Hsv);
    m_defaultsMap[RecordFaderOutline] = TQColor(0, 250, 225, TQColor::Hsv);
}

GUIPalette* GUIPalette::getInstance() 
{
    if (!m_instance) m_instance = new GUIPalette();
    return m_instance;
}

const char* const GUIPalette::ActiveRecordTrack = "activerecordtrack";


const char* const GUIPalette::SegmentCanvas = "segmentcanvas";
const char* const GUIPalette::SegmentBorder = "segmentborder";
const char* const GUIPalette::RecordingInternalSegmentBlock = "recordinginternalsegmentblock";
const char* const GUIPalette::RecordingAudioSegmentBlock = "recordingaudiosegmentblock";
const char* const GUIPalette::RecordingSegmentBorder = "recordingsegmentborder";

const char* const GUIPalette::RepeatSegmentBorder = "repeatsegmentborder";

const char* const GUIPalette::SegmentAudioPreview = "segmentaudiopreview";
const char* const GUIPalette::SegmentInternalPreview = "segmentinternalpreview";
const char* const GUIPalette::SegmentLabel = "segmentlabel";
const char* const GUIPalette::SegmentSplitLine = "segmentsplitline";

const char* const GUIPalette::MatrixElementBorder = "matrixelementborder";
const char* const GUIPalette::MatrixElementBlock = "matrixelementblock";
const char* const GUIPalette::MatrixOverlapBlock = "matrixoverlapblock";

const char* const GUIPalette::LoopRulerBackground = "looprulerbackground";
const char* const GUIPalette::LoopRulerForeground = "looprulerforeground";
const char* const GUIPalette::LoopHighlight = "loophighlight";

const char* const GUIPalette::TempoBase = "tempobase";

const char* const GUIPalette::TextRulerBackground = "textrulerbackground";
const char* const GUIPalette::TextRulerForeground = "textrulerforeground";

const char* const GUIPalette::ChordNameRulerBackground = "chordnamerulerbackground";
const char* const GUIPalette::ChordNameRulerForeground = "chordnamerulerforeground";

const char* const GUIPalette::RawNoteRulerBackground = "rawnoterulerbackground";
const char* const GUIPalette::RawNoteRulerForeground = "rawnoterulerforeground";

const char* const GUIPalette::LevelMeterGreen = "levelmetergreen";
const char* const GUIPalette::LevelMeterOrange = "levelmeterorange";
const char* const GUIPalette::LevelMeterRed = "levelmeterred";

const char* const GUIPalette::LevelMeterSolidGreen = "levelmetersolidgreen";
const char* const GUIPalette::LevelMeterSolidOrange = "levelmetersolidorange";
const char* const GUIPalette::LevelMeterSolidRed = "levelmetersolidred";

const char* const GUIPalette::BarLine = "barline";
const char* const GUIPalette::BarLineIncorrect = "barlineincorrect";
const char* const GUIPalette::BeatLine = "beatline";
const char* const GUIPalette::SubBeatLine = "subbeatline";
const char* const GUIPalette::StaffConnectingLine = "staffconnectingline";
const char* const GUIPalette::StaffConnectingTerminatingLine = "staffconnectingterminatingline";

const char* const GUIPalette::Pointer = "pointer";
const char* const GUIPalette::PointerRuler = "pointerruler";

const char* const GUIPalette::InsertCursor = "insertcursor";
const char* const GUIPalette::InsertCursorRuler = "insertcursorruler";

const char* const GUIPalette::TrackDivider = "trackdivider";
const char* const GUIPalette::MovementGuide = "movementguide";
const char* const GUIPalette::SelectionRectangle = "selectionrectangle";
const char* const GUIPalette::SelectedElement = "selectedelement";

const int GUIPalette::SelectedElementHue = 225;
const int GUIPalette::SelectedElementMinValue = 220;
const int GUIPalette::HighlightedElementHue = 25;
const int GUIPalette::HighlightedElementMinValue = 220;
const int GUIPalette::QuantizedNoteHue = 69;
const int GUIPalette::QuantizedNoteMinValue = 140;
const int GUIPalette::TriggerNoteHue = 4;
const int GUIPalette::TriggerNoteMinValue = 140;
const int GUIPalette::OutRangeNoteHue = 0;
const int GUIPalette::OutRangeNoteMinValue = 200;

const int GUIPalette::CollisionHaloHue = 42;
const int GUIPalette::CollisionHaloSaturation = 200;

const char* const GUIPalette::TextAnnotationBackground = "textannotationbackground";

const char* const GUIPalette::TextLilyPondDirectiveBackground = "textlilyponddirectivebackground";

const char* const GUIPalette::AudioCountdownBackground = "audiocountdownbackground";
const char* const GUIPalette::AudioCountdownForeground = "audiocountdownforeground";

const char* const GUIPalette::RotaryFloatBackground = "rotaryfloatbackground";
const char* const GUIPalette::RotaryFloatForeground = "rotaryfloatforeground";

const char* const GUIPalette::RotaryPastelBlue = "rotarypastelblue";
const char* const GUIPalette::RotaryPastelRed = "rotarypastelred";
const char* const GUIPalette::RotaryPastelGreen = "rotarypastelgreen";
const char* const GUIPalette::RotaryPastelOrange = "rotarypastelorange";
const char* const GUIPalette::RotaryPastelYellow = "rotarypastelyellow";

const char* const GUIPalette::MatrixKeyboardFocus = "matrixkeyboardfocus";

const char* const GUIPalette::RotaryPlugin = "rotaryplugin";

const char* const GUIPalette::RotaryMeter = "rotarymeter";

const char* const GUIPalette::MarkerBackground = "markerbackground";

const char* const GUIPalette::QuickMarker = "quickmarker";

const char* const GUIPalette::MuteTrackLED = "mutetrackled";
const char* const GUIPalette::RecordMIDITrackLED = "recordmiditrackled";
const char* const GUIPalette::RecordAudioTrackLED = "recordaudiotrackled";

const char* const GUIPalette::PlaybackFaderOutline = "playbackfaderoutline";
const char* const GUIPalette::RecordFaderOutline = "recordfaderoutline";

 
GUIPalette* GUIPalette::m_instance = 0;

// defines which index in the document's colourmap should be used as the color
// when creating new audio segments from recordings, or inserting from the
// audio file manager (presumes a file derived from the updated autoload.rg
// that shipped along with this change)
const int GUIPalette::AudioDefaultIndex = 1;

}
