/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    This file is Copyright 2006
        Pedro Lopez-Cabanillas <plcl@users.sourceforge.net>
        D. Michael McIntyre <dmmcintyr@users.sourceforge.net>

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TRACKPARAMETERBOX_H_
#define _RG_TRACKPARAMETERBOX_H_

#include "base/MidiProgram.h"
#include "base/Track.h"
#include "gui/widgets/ColourTable.h"
#include <map>
#include "RosegardenParameterArea.h"
#include "RosegardenParameterBox.h"
#include <tqstring.h>
#include <tqcheckbox.h> // #include <TQCheckBox> in QT4, thinking ahead
#include <vector>


class TQWidget;
class TQPushButton;
class TQLabel;
class TQFrame;
class KComboBox;
class TQCheckBox;


namespace Rosegarden
{

class RosegardenGUIDoc;


class TrackParameterBox : public RosegardenParameterBox
{
Q_OBJECT
  TQ_OBJECT
        
public:
    TrackParameterBox( RosegardenGUIDoc *doc,
                       TQWidget *parent=0);
    ~TrackParameterBox();
    
    void setDocument( RosegardenGUIDoc *doc );
    void populateDeviceLists();
    virtual void showAdditionalControls(bool showThem);

    virtual TQString getPreviousBox(RosegardenParameterArea::Arrangement) const;

public slots:
    void slotSelectedTrackChanged();
    void slotSelectedTrackNameChanged();
    void slotPlaybackDeviceChanged(int index);
    void slotInstrumentChanged(int index);
    void slotRecordingDeviceChanged(int index);
    void slotRecordingChannelChanged(int index);
    void slotUpdateControls(int);
    void slotInstrumentLabelChanged(InstrumentId id, TQString label);

    void slotClefChanged(int clef);
    void slotTransposeChanged(int transpose);
    void slotTransposeIndexChanged(int index);
    void slotTransposeTextChanged(TQString text);
    void slotDocColoursChanged();
    void slotColorChanged(int index);
    void slotHighestPressed();
    void slotLowestPressed();
    void slotPresetPressed();

    void slotStaffSizeChanged(int index);
    void slotStaffBracketChanged(int index);

signals:
    void instrumentSelected(TrackId, int);

protected:
    void populatePlaybackDeviceList();
    void populateRecordingDeviceList();
    void updateHighLow();

private:
    RosegardenGUIDoc    *m_doc;

    KComboBox           *m_playDevice;
    KComboBox           *m_instrument;
    KComboBox           *m_recDevice;
    KComboBox           *m_recChannel;

    TQPushButton         *m_presetButton;
    TQPushButton         *m_highButton;
    TQPushButton         *m_lowButton;

    KComboBox           *m_defClef;
    KComboBox           *m_defColor;
    KComboBox           *m_defTranspose;
    KComboBox           *m_staffSizeCombo;
    KComboBox           *m_staffBracketCombo;


    int                 m_addColourPos;
    int                 m_highestPlayable;
    int                 m_lowestPlayable;
    ColourTable::ColourList  m_colourList;
    
    TQLabel              *m_trackLabel;
    
    typedef std::vector<DeviceId> IdsVector;
    
    IdsVector           m_playDeviceIds;    
    IdsVector           m_recDeviceIds;

    std::map<DeviceId, IdsVector>   m_instrumentIds;
    std::map<DeviceId, TQStringList> m_instrumentNames;
    
    int                 m_selectedTrackId;
    
    char                m_lastInstrumentType;

    // Additional elements that may be hidden in vertical stacked mode
    //TQFrame              *m_separator2;
    TQFrame              *m_playbackGroup;
    TQFrame              *m_recordGroup;
    TQFrame              *m_defaultsGroup;
    TQFrame              *m_staffGroup;
    TQLabel              *m_segHeader;
    TQLabel              *m_presetLbl;
    TQLabel              *m_staffGrpLbl;
    TQLabel              *m_grandStaffLbl;
    TQLabel              *m_clefLbl;
    TQLabel              *m_transpLbl;
    TQLabel              *m_colorLbl;
    TQLabel              *m_rangeLbl;
    TQLabel              *m_psetLbl;
};


}

#endif
