
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_CLEFDIALOG_H_
#define _RG_CLEFDIALOG_H_

#include "base/NotationTypes.h"
#include <kdialogbase.h>


class TQWidget;
class TQRadioButton;
class TQLabel;


namespace Rosegarden
{

class BigArrowButton;
class NotePixmapFactory;


class ClefDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    enum ConversionType {
        NoConversion,
        ChangeOctave,
        Transpose,
    };

    ClefDialog(TQWidget *parent,
               NotePixmapFactory *npf,
               Clef defaultClef,
               bool showConversionOptions = true);

    Clef getClef() const;
    ConversionType getConversionType() const;

public slots:
    void slotClefUp();
    void slotClefDown();
    void slotOctaveUp();
    void slotOctaveDown();

protected:
    void redrawClefPixmap();

    //--------------- Data members ---------------------------------

    NotePixmapFactory *m_notePixmapFactory;
    Clef m_clef;
    
    TQLabel *m_clefLabel;
    TQLabel *m_clefNameLabel;

    BigArrowButton *m_octaveUp;
    BigArrowButton *m_octaveDown;

    TQRadioButton *m_noConversionButton;
    TQRadioButton *m_changeOctaveButton;
    TQRadioButton *m_transposeButton;   
};



}

#endif
