
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_STARTUPTESTER_H_
#define _RG_STARTUPTESTER_H_

#include <tqmutex.h>
#include <tqthread.h>
#include <tqstringlist.h>
#include <tqobject.h>
#include <tqhttp.h>

class KProcess;

namespace Rosegarden
{

class StartupTester : public TQObject, public TQThread
{
    Q_OBJECT
  TQ_OBJECT

public:
    StartupTester();
    virtual ~StartupTester();
    
    virtual void run();

    bool isReady();
    
    // If you call one of these methods before the startup test has
    // completed in the background, then it will block.
    
    bool haveProjectPackager(TQStringList *missingApplications);
    bool haveLilyPondView(TQStringList *missingApplications);
    bool haveAudioFileImporter(TQStringList *missingApplications);

signals:
    void newerVersionAvailable(TQString);

protected slots:
    void stdoutReceived(KProcess *, char *, int);

    void slotHttpResponseHeaderReceived(const TQHttpResponseHeader &);
    void slotHttpDone(bool);

protected:
    bool m_ready;
    TQMutex m_projectPackagerMutex;
    TQMutex m_lilyPondViewMutex;
    TQMutex m_audioFileImporterMutex;
    bool m_haveProjectPackager;
    TQStringList m_projectPackagerMissing;
    bool m_haveLilyPondView;
    TQStringList m_lilyPondViewMissing;
    bool m_haveAudioFileImporter;
    TQStringList m_audioFileImporterMissing;
    TQString m_stdoutBuffer;
    bool m_versionHttpFailed;
    void parseStdoutBuffer(TQStringList &target);
    bool isVersionNewerThan(TQString, TQString);
};


}

#endif
