/****************************************************************************
** $Id$
**
** Definition of QMultiInputContext class
**
** Copyright (C) 2004 immodule for Qt Project.  All rights reserved.
**
** This file is written to contribute to Trolltech AS under their own
** licence. You may use this file under your Qt license. Following
** description is copied from their original file headers. Contact
** immodule-qt@freedesktop.org if any conditions of this licensing are
** not clear to you.
**
**
** This file is part of the input method module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QMULTIINPUTCONTEXT_H
#define QMULTIINPUTCONTEXT_H

#ifndef QT_NO_IM

#include <qnamespace.h>
#include <qwidget.h>
#include <qinputcontext.h>
#include <qguardedptr.h>
#include <qintdict.h>

class QPopupMenu;

class QMultiInputContext : public QInputContext
{
    Q_OBJECT
public:
    QMultiInputContext();
    ~QMultiInputContext();

    QString identifierName();
    QString language();

#if defined(Q_WS_X11)
    bool x11FilterEvent( QWidget *keywidget, XEvent *event );
#endif // Q_WS_X11
    bool filterEvent( const QEvent *event );
    void reset();

    void setFocus();
    void unsetFocus();
    void setMicroFocus( int x, int y, int w, int h, QFont *f = 0 );
    void mouseHandler( int x, QEvent::Type type,
		       Qt::ButtonState button, Qt::ButtonState state );
    QFont font() const;
    bool isComposing() const;
    bool isPreeditRelocationEnabled();
    
#if (QT_VERSION-0 >= 0x040000)
    QPtrList<QMenu> *qt4menus();
#endif
    QPtrList<QInputContextMenu> *menus();
    QPopupMenu *createImSelPopup();    

#if defined(Q_WS_X11)
    QWidget *focusWidget() const;
    QWidget *holderWidget() const;

    void setFocusWidget( QWidget *w );
    void setHolderWidget( QWidget *w );
    void releaseComposingWidget( QWidget *w );
#endif

public slots:
    virtual void destroyInputContext();
    virtual void postIMEvent( QObject *receiver, QIMEvent *event );

protected slots:
    void changeInputMethodWithMenuId( int menuid );

protected:
    QInputContext *slave();
    const QInputContext *slave() const;
    
    void changeInputMethod( int newIndex );
    void changeInputMethod( QString name );

    QInputContext *_slave;
    int imIndex;
    bool cachedFocus;
    QWidget *cachedFocusWidget;
    QWidget *cachedHolderWidget;
    bool beIndirectlyConnected;

    QIntDict<QString> keyDict;
    QGuardedPtr<QPopupMenu> popup;
    QString currentIMKey;
};

#endif //Q_NO_IM

#endif // QMULTIINPUTCONTEXT_H
