# Copyright (c) 2004
#   Riverbank Computing Limited <info@riverbankcomputing.co.uk>
#   Jim Bublitz <jbublitz@nwinternet.com>
#
# This file is part of PyKDE.
#
# This copy of PyKDE is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
#
# PyKDE is supplied in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# PyKDE; see the file LICENSE.  If not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# This module is intended to be used by the configuration scripts of extension
# modules that %Import PyKDE modules.


import sipconfig, pyqtconfig


# These are installation specific values created when PyQt was configured.
_pkg_config = {
    'dist_name':            '',
    'kde_version':          0x030503,
    'kde_version_extra':    'kde353',
    'kde_version_sfx':      '-kde353.diff',
    'kde_version_str':      '3.5.3',
    'kdebasedir':           '/opt/trinity',
    'kdeincdir':            '/opt/trinity/include',
    'kdelibdir':            '/opt/trinity/lib',
    'libdir':               'lib',
    'pykde_kde_sip_flags':  '-t ALL -x Qt_STYLE_WINDOWSXP -x Qt_STYLE_INTERLACE -x Qt_STYLE_WINDOWSXP -x Qt_SIP_PRE_4_7_2 -x VendorID -t WS_X11 -t Qt_3_3_6 -t KDE_3_5_3',
    'pykde_mod_dir':        '/usr/lib/python2.5/site-packages',
    'pykde_modules':        'dcop kdecore kdefx kdeui kio kresources kabc kutils kfile kparts khtml kspell kdeprint kmdi',
    'pykde_sip_dir':        '/usr/share/sip',
    'pykde_version':        0x031000,
    'pykde_version_str':    '3.16.0'
}

_default_macros = None


class Configuration(pyqtconfig.Configuration):
    """The class that represents PyQt configuration values.
    """
    def __init__(self, sub_cfg=None):
        """Initialise an instance of the class.

        sub_cfg is the list of sub-class configurations.  It should be None
        when called normally.
        """
        if sub_cfg:
            cfg = sub_cfg
        else:
            cfg = []

        cfg.append(_pkg_config)

        pyqtconfig.Configuration.__init__(self, cfg)


class DCOPModuleMakefile(pyqtconfig.QtModuleMakefile):
    """The Makefile class for modules that %Import DCOP.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pykde_mod_dir)
            self.LIBDIR.append(self.config.pykde_lib_dir)
            self.extra_libs.append(self.module_as_lib("DCOP"))

        pyqtconfig.QtModuleMakefile.finalise(self)

class KdecoreModuleMakefile(DCOPModuleMakefile):
    """The Makefile class for modules that %Import kdecore.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kdecore"))

        DCOPModuleMakefile.finalise(self)

class KdesuModuleMakefile(KdecoreModuleMakefile):
    """The Makefile class for modules that %Import kdesu.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kdesu"))

        KdecoreModuleMakefile.finalise(self)

class KdefxModuleMakefile(KdecoreModuleMakefile):
    """The Makefile class for modules that %Import kdefx.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kdefx"))

        KdecoreModuleMakefile.finalise(self)

class KdeuiModuleMakefile(KdefxModuleMakefile):
    """The Makefile class for modules that %Import kdeui.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kdeui"))

        if self.config.sip_version < 0x040000:
            self.extra_libs.append(self.module_as_lib("qtxml"))

        KdefxModuleMakefile.finalise(self)

class KioModuleMakefile(KdeuiModuleMakefile):
    """The Makefile class for modules that %Import kio.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kio"))

        KdeuiModuleMakefile.finalise(self)

class KfileModuleMakefile(KioModuleMakefile):
    """The Makefile class for modules that %Import kfile.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kfile"))

        KioModuleMakefile.finalise(self)

class KpartsModuleMakefile(KfileModuleMakefile):
    """The Makefile class for modules that %Import kparts.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kparts"))

        KfileModuleMakefile.finalise(self)

class KhtmlModuleMakefile(KpartsModuleMakefile):
    """The Makefile class for modules that %Import khtml.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("khtml"))

        KpartsModuleMakefile.finalise(self)

class KjsModuleMakefile(KhtmlModuleMakefile):
    """The Makefile class for modules that %Import kjs.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kjs"))

        KjsModuleMakefile.finalise(self)

class KdeprintModuleMakefile(KdeuiModuleMakefile):
    """The Makefile class for modules that %Import kdeprint.
    """
    def finalise(self):
        """Finalise the macros.
        """
        if self.config.sip_version < 0x040000:
            # Note that we don't use self.extra_lib_dirs because we don't want
            # it to be added to the rpath.
            self.LIBDIR.append(self.config.pyqt_mod_dir)
            self.extra_libs.append(self.module_as_lib("kdeprint"))

        KdeuiModuleMakefile.finalise(self)
