/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "potracegui.h"
#include "mainwidget.h"

#include <tqlabel.h>
#include <tqclipboard.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kio/netaccess.h>
#include <kimageio.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kmessagebox.h>

potracegui::potracegui()
    : KMainWindow( 0, "potracegui" ), m_centralWidget(new MainWidget(this))
{
	// set the shell's ui resource file
	setXMLFile("potraceguiui.rc");
	KImageIO::registerFormats();
	 
	setCentralWidget(m_centralWidget);
	
	setAcceptDrops(true);
	 
	statusBar()->show();
	statusBar()->message(i18n("Welcome to PotraceGui 1.3"));
	setAutoSaveSettings();
	setAcceptDrops(true);

	connect(m_centralWidget,TQT_SIGNAL(signalChangeStatusbar(TQString)),this,TQT_SLOT(changeStatusbar(TQString)));
	 
	createInterface();
}

potracegui::~potracegui()
{
}

void potracegui::createInterface()
{
	 /*handled by potracegui*/
	 KStdAction::openNew(TQT_TQOBJECT(this), TQT_SLOT(fileNew()),actionCollection());
	 KStdAction::quit(TQT_TQOBJECT(this), TQT_SLOT(quit()),actionCollection());
	 m_toolbarAction=KStdAction::showToolbar(TQT_TQOBJECT(this), TQT_SLOT(showToolbar()),actionCollection());
	 m_statusbarAction=KStdAction::showStatusbar(TQT_TQOBJECT(this), TQT_SLOT(showStatusbar()),actionCollection());
	 KStdAction::keyBindings(TQT_TQOBJECT(this), TQT_SLOT(configureKeys()),actionCollection());
	 KStdAction::configureToolbars(TQT_TQOBJECT(this), TQT_SLOT(configureTB()),actionCollection());
	 
	 /*handled by MainWidget*/
	 KStdAction::open(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(fileOpen()),actionCollection());
	 KStdAction::save(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(fileSave()),actionCollection());
	 KStdAction::saveAs(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(fileSaveAs()),actionCollection());
	 KStdAction::close(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(fileClose()),actionCollection());
	 KStdAction::cut(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(cut()),actionCollection());
	 KStdAction::copy(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(copy()),actionCollection());
	 KStdAction::paste(TQT_TQOBJECT(m_centralWidget), TQT_SLOT(paste()),actionCollection());
	 
	 /*Create menu and toolbar*/
	 createGUI();
}


//MENU ACTIONS
void potracegui::fileNew()
{
	(new potracegui)->show();
}

void potracegui::quit()
{
	close();
}

void potracegui::showToolbar()
{
	if(m_toolbarAction->isChecked())
		toolBar()->show();
	else
		toolBar()->hide();
}

void potracegui::showStatusbar()
{
	if(m_statusbarAction->isChecked())
		statusBar()->show();
	else
		statusBar()->hide();
}

void potracegui::configureKeys()
{
	KKeyDialog::configure(actionCollection(),"potraceguiui.rc");
}

void potracegui::configureTB()
{
	KEditToolbar dlg(actionCollection());
	connect(&dlg,TQT_SIGNAL(newToolbarConfig()),this,TQT_SLOT(NewTBConfig()));
	dlg.exec();
}

void potracegui::NewTBConfig()
{
	createGUI();
	saveMainWindowSettings(KGlobal::config());
}

void potracegui::changeStatusbar(TQString message)
{
	statusBar()->message(message);
}

bool potracegui::queryClose() {
	if(m_centralWidget->m_changed) {
		int res= KMessageBox::warningYesNoCancel(this, i18n("Save changes?"));
		if(res==KMessageBox::Yes) {
			m_centralWidget->fileSave();
			return true;
		}
		else if(res==KMessageBox::Cancel) {
			return false;
		}
		if(res==KMessageBox::No) {
			return true;
		}
	}
	return true;
}

#include "potracegui.moc"
