//////////////////////////////////////////////////////////////////////////////
//
//    BATCHPROGRESSDIALOG.CPP
//
//    Copyright (C) 2004 Gilles Caulier <caulier dot gilles at free.fr>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU Library General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////


// Include files for TQt

#include <tqvbox.h>
#include <tqlayout.h>
#include <tqdir.h>
#include <tqwidget.h>
#include <tqgroupbox.h>
#include <tqwhatsthis.h>
#include <tqcolor.h>
#include <tqhgroupbox.h>
#include <tqvgroupbox.h>
#include <tqheader.h>
#include <tqlistview.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqcolor.h>
#include <tqpixmap.h>
#include <tqpushbutton.h>

// Include files for KDE

#include <klocale.h>
#include <kprogress.h>
#include <kinstance.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <klistview.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <kaboutdata.h>
#include <khelpmenu.h>
#include <kiconloader.h>
#include <kpopupmenu.h>

// Include files for libKipi.

#include "libkipi/version.h"

// Local includes

#include "batchprogressdialog.h"

namespace KIPI
{

class BatchProgressItem : public KListViewItem
{
public:
   BatchProgressItem(KListView * parent, TQListViewItem *after, const TQString &message, int messageType)
                   : KListViewItem( parent, after), m_messagetype(messageType)
   {
   // Set the icon.

   switch( m_messagetype )
     {
     case KIPI::StartingMessage:
        setPixmap( 0, SmallIcon( "run" ) );
        break;
     case KIPI::SuccessMessage:
        setPixmap( 0, SmallIcon( "ok" ) );
        break;
     case KIPI::WarningMessage:
        setPixmap( 0, SmallIcon( "flag" ) );
        break;
     case KIPI::ErrorMessage:
        setPixmap( 0, SmallIcon( "stop" ) );
        break;
     case KIPI::ProgressMessage:
        setPixmap( 0, SmallIcon( "info" ) );
        break;
     default:
        setPixmap( 0, SmallIcon( "info" ) );
     }

   // Set the message text.

   setText(1, message);
   }

private:
   int m_messagetype;

   void paintCell (TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment)
      {
      TQColorGroup _cg( cg );

      if ( m_messagetype == KIPI::ErrorMessage )
          {
          _cg.setColor( TQColorGroup::Text, TQt::red );
          KListViewItem::paintCell( p, _cg, column, width, alignment );
          return;
          }

      if ( m_messagetype == KIPI::WarningMessage )
          {
          _cg.setColor( TQColorGroup::Text, TQt::darkYellow );
          KListViewItem::paintCell( p, _cg, column, width, alignment );
          return;
          }

      KListViewItem::paintCell( p, cg, column, width, alignment );
      }
};


struct BatchProgressDialog::Private {
};


/////////////////////////////////// CONSTRUCTOR ////////////////////////////////////////////

BatchProgressDialog::BatchProgressDialog( TQWidget *parent, const TQString &caption )
                   : KDialogBase( parent, "KIPIBatchProgressDialog", true /* modal */,
                                  caption, Cancel)
{
    d = new Private;
    TQWidget* box = makeVBoxMainWidget();

    //---------------------------------------------

    TQFrame *headerFrame = new TQFrame( box );
    headerFrame->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);
    TQHBoxLayout* layout = new TQHBoxLayout( headerFrame );
    layout->setMargin( 2 ); // to make sure the frame gets displayed
    layout->setSpacing( 0 );
    TQLabel *pixmapLabelLeft = new TQLabel( headerFrame, "pixmapLabelLeft" );
    pixmapLabelLeft->setScaledContents( false );
    layout->addWidget( pixmapLabelLeft );
    TQLabel *labelTitle = new TQLabel( caption, headerFrame, "labelTitle" );
    layout->addWidget( labelTitle );
    layout->setStretchFactor( labelTitle, 1 );

    TQString dir;
    KGlobal::dirs()->addResourceType("kipi_banner_left", KGlobal::dirs()->kde_default("data") + "kipi/data");
    dir = KGlobal::dirs()->findResourceDir("kipi_banner_left", "banner_left.png");

    pixmapLabelLeft->setPaletteBackgroundColor( TQColor(201, 208, 255) );
    pixmapLabelLeft->setPixmap( TQPixmap( dir + "banner_left.png" ) );
    labelTitle->setPaletteBackgroundColor( TQColor(201, 208, 255) );

    //---------------------------------------------


    m_actionsList = new KListView( box );
    m_actionsList->addColumn(i18n( "Status" ));
    m_actionsList->addColumn(i18n( "Current Actions" ));
    m_actionsList->setSorting(-1);
    m_actionsList->setItemMargin(1);
    m_actionsList->header()->hide();
    m_actionsList->setResizeMode(TQListView::LastColumn);
    TQWhatsThis::add( m_actionsList, i18n("<p>This is the current tasks list released.") );

    //---------------------------------------------

    m_progress = new KProgress( box, "Progress" );
    m_progress->setTotalSteps(100);
    m_progress->setValue(0);
    TQWhatsThis::add( m_progress, i18n("<p>This is the list current percent task released.") );
    resize( 600, 400 );
}


//////////////////////////////////// DESTRUCTOR /////////////////////////////////////////////

BatchProgressDialog::~BatchProgressDialog()
{
    delete d;
}


///////////////////////////////////// FONCTIONS /////////////////////////////////////////////

void BatchProgressDialog::addedAction(const TQString &text, int type)
{
    m_item = new KIPI::BatchProgressItem(m_actionsList,
                                         m_actionsList->lastItem(),
                                         text, type);

    m_actionsList->ensureItemVisible(m_item);
}


void BatchProgressDialog::reset()
{
    m_actionsList->clear();
    m_progress->setValue(0);
}


void BatchProgressDialog::setProgress(int current, int total)
{
    m_progress->setTotalSteps(total);
    m_progress->setValue(current);
}

}  // NameSpace KIPI

#include "batchprogressdialog.moc"
