/* vi: ts=8 sts=4 sw=4
 *
 * $Id: krootpixmap.h,v 1.15 2003/05/19 08:02:48 coolo Exp $
 * This file is part of the KDE project, module kdesktop.
 * Copyright (C) 1999,2000 Geert Jansen <jansen@kde.org>
 *
 * You can Freely distribute this program under the GNU Library General
 * Public License. See the file "COPYING.LIB" for the exact licensing terms.
 */

/* Modified by Sascha Hlusiak */
 

#ifndef __KRootPixmap_h_Included__
#define __KRootPixmap_h_Included__

#include <tqobject.h>
#include <tqcolor.h>

#ifndef TQ_WS_TQWS //FIXME

class TQRect;
class TQWidget;
class TQTimer;
class KSharedPixmap;
class KMyRootPixmapData;

class KMyRootPixmap: public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:
    KMyRootPixmap( TQWidget *target=NULL, const char *name=0 );

    KMyRootPixmap( TQWidget *target, TQObject *parent, const char *name=0 );

    virtual ~KMyRootPixmap();

    bool isAvailable();

    bool isActive() const { return m_bActive; }

    int currentDesktop() const;

//    bool customPainting() const { return m_bCustomPaint; }

#ifndef KDE_NO_COMPAT

    bool checkAvailable(bool) { return isAvailable(); }
#endif

public slots:
    virtual void start();

    virtual void stop();

//    void setFadeEffect(double strength, const TQColor &color);

    void repaint( bool force );

    void repaint();

//    void setCustomPainting( bool enable ) { m_bCustomPaint = enable; }

    void enableExports();

    static TQString pixmapName(int desk);
    
signals:
    void backgroundUpdated( const TQImage *pm );

protected:
//    virtual bool eventFilter(TQObject *, TQEvent *);

    virtual void updateBackground( KSharedPixmap * );

private slots:
//    void slotBackgroundChanged(int);
    void slotDone(bool);

private:
    bool m_bActive, m_bInit/*, m_bCustomPaint*/;
    int m_Desk;

//    double m_Fade;
//    TQColor m_FadeColor;

    TQRect m_Rect;
//    TQWidget *m_pWidget;
//    TQTimer *m_pTimer;
    KSharedPixmap *m_pPixmap;
//    KMyRootPixmapData *d;

    void init();
};

#endif // ! TQ_WS_TQWS
#endif // __KRootPixmap_h_Included__
