#include "VButton.h"
#include <tqvbox.h>
#include <tqfont.h>

double VButton::pw=550.0;
double VButton::ph=235.0;

VButton::VButton(TQWidget *parent, const char *name): TQPushButton (parent,name)
{
	
	//connect(this,TQT_SIGNAL(clicked()),this,TQT_SLOT(sendKey()));
	setFocusPolicy(TQ_NoFocus);
	resize(30,30);
	press=false;

}
VButton::~VButton()
{

}
void VButton::shiftPressed(bool press)
{
	if (press==true){	
		TQString tu=l.upper();
		if (tu.compare(l)==0){
			//TQPushButton::setText(tu);
			TQPushButton::setText(u);
		}
		else{
			TQPushButton::setText(tu);
		}

	}
	else{
		TQPushButton::setText(l);
	}
}
void VButton::capsPressed(bool press)
{
	if (press==true){	
		TQString tu=l.upper();
		if (tu.compare(l)==0){
			TQPushButton::setText(tu);
		}
		else{
			TQPushButton::setText(u);
		}
	}
	else{
		TQPushButton::setText(l);
	}
}

void VButton::setText(const TQString& text)
{
	TQPushButton::setText(text);
	l=text;
}
void VButton::setShiftText(const TQString& text)
{
	u=text;
}

void VButton::setKeyCode(unsigned int keycode)
{
	this->keycode=keycode;
	
}
unsigned int VButton::getKeyCode()
{
	return this->keycode;
}
void VButton::sendKey()
{
	emit keyClick(keycode);
}

void VButton::reposition(int width, int height)
{
	double dx=pw/orig_size.x();
	double dy=ph/orig_size.y();
	double sdx=pw/orig_size.width();
	double sdy=ph/orig_size.height();
	move((int)(width/dx),(int)(height/dy));
	resize((int)(width/sdx), (int)(height/sdy));

}
void VButton::res()
{
	orig_size=geometry();
}

void VButton::mousePressEvent(TQMouseEvent * e)
{
	press=true;
	TQPushButton::mousePressEvent(e);
	sendKey();
	startTimer(500);
}

void VButton::mouseReleaseEvent(TQMouseEvent * e)
{
	press=false;
	TQPushButton::mouseReleaseEvent(e);
	TQT_TQOBJECT(this)->killTimers();
	inrpt=false;                                                                        
}

void VButton::timerEvent(TQTimerEvent *)
{
	if (!press){
		inrpt=false;
		return;
	}
	if (press && !inrpt) {
		inrpt=true;
		startTimer(120);
		return;
	}
	sendKey();
}
