#ifndef _OPTW_MEDIATYPES_H_
#define _OPTW_MEDIATYPES_H_

//
//   File : optw_mediatypes.h
//   Creation date : Sat Jan 20 2001 16:12:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_optionswidget.h"
#include "kvi_tal_listview.h"
#include <tqlineedit.h>
#include <tqpushbutton.h>

#include "kvi_mediatype.h"

class KviMediaTypeListViewItem : public KviTalListViewItem
{
public:
	KviMediaTypeListViewItem(KviTalListView * w,KviMediaType * t);
	~KviMediaTypeListViewItem();
private:
	KviMediaType m_data;
public:
	void copyData(KviMediaType * t);
	const KviMediaType * data(){ return &m_data; };
};

#define KVI_OPTIONS_WIDGET_ICON_KviMediaTypesOptionsWidget KVI_SMALLICON_FILE
#define KVI_OPTIONS_WIDGET_NAME_KviMediaTypesOptionsWidget __tr2qs_no_lookup("Media Types")
#define KVI_OPTIONS_WIDGET_PARENT_KviMediaTypesOptionsWidget KviGeneralOptOptionsWidget
#define KVI_OPTIONS_WIDGET_KEYWORDS_KviMediaTypesOptionsWidget __tr2qs_no_lookup("file,audio,video,programs")
#define KVI_OPTIONS_WIDGET_PRIORITY_KviMediaTypesOptionsWidget 60000
//#define KVI_OPTIONS_WIDGET_HIDDEN_KviMediaTypesOptionsWidget true

class KviMediaTypesOptionsWidget : public KviOptionsWidget
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviMediaTypesOptionsWidget(TQWidget * parent);
	~KviMediaTypesOptionsWidget();
private:
	KviTalListView   * m_pListView;
	TQLineEdit   * m_pDescription;
	TQLineEdit   * m_pIanaType;
	TQLineEdit   * m_pFileMask;
	TQLineEdit   * m_pSavePath;
	TQLineEdit   * m_pCommandline;
	TQLineEdit   * m_pMagicBytes;
	TQLineEdit   * m_pRemoteExecCommandline;
	TQLineEdit   * m_pIcon;
	TQPushButton * m_pDelete;
	KviMediaTypeListViewItem * m_pLastItem;
private:
	void fillListView();
	void saveLastItem();
	void enableOrDisable();
	void setLineEdits();
private slots:
	void currentItemChanged(KviTalListViewItem *it);
	void newMediaType();
	void delMediaType();
public:
	virtual void commit();
};

#endif //!_OPTW_IDENTITY_H_
