#ifndef _CANVAS_WIDGET_H_
#define _CANVAS_WIDGET_H_
//
//   File : canvaswidget.h
//   Creation date : Mon Jul 30 07 2001 04:49:49 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "broker.h"

#ifdef COMPILE_DCC_CANVAS


#include <tqcanvas.h>

//#ifdef TQT_NO_CANVAS
//	#warning "HEre is not"
//#endif


#include <tqmenubar.h>
#include <tqlabel.h>

#include <tqmap.h>
#include <tqvariant.h>
#include <tqtable.h>
#include <tqsplitter.h>



class KviCanvasWidget;



#define KVI_CANVAS_RTTI_CONTROL_TYPE_RECTANGLE 1
#define KVI_CANVAS_RTTI_CONTROL_TYPE_LINE 2
#define KVI_CANVAS_RTTI_CONTROL_TYPE_POLYGON 4

#define KVI_CANVAS_RTTI_CONTROL_TYPE_MASK 255

#define KVI_CANVAS_RTTI_RECTANGLE (KVI_CANVAS_RTTI_CONTROL_TYPE_RECTANGLE | (1 << 8))
#define KVI_CANVAS_RTTI_RICHTEXT  (KVI_CANVAS_RTTI_CONTROL_TYPE_RECTANGLE | (2 << 8))
#define KVI_CANVAS_RTTI_LINE      (KVI_CANVAS_RTTI_CONTROL_TYPE_LINE | (3 << 8))
#define KVI_CANVAS_RTTI_ELLIPSE   (KVI_CANVAS_RTTI_CONTROL_TYPE_RECTANGLE | (4 << 8))
#define KVI_CANVAS_RTTI_CHORD     (KVI_CANVAS_RTTI_CONTROL_TYPE_RECTANGLE | (5 << 8))
#define KVI_CANVAS_RTTI_PIE       (KVI_CANVAS_RTTI_CONTROL_TYPE_RECTANGLE | (6 << 8))
#define KVI_CANVAS_RTTI_POLYGON   (KVI_CANVAS_RTTI_CONTROL_TYPE_POLYGON | (7 << 8))

#define KVI_CANVAS_RTTI_CONTROL_TYPE(__item) (__item->rtti() & KVI_CANVAS_RTTI_CONTROL_TYPE_MASK)



class KviCanvasPolygon : public TQCanvasPolygon
{
public:
	KviCanvasPolygon(TQCanvas * c,int x,int y,TQPointArray &pnts,double dScaleFactor);
	virtual ~KviCanvasPolygon();
protected:
	TQMap<TQString,TQVariant> m_properties;
	double                 m_dScaleFactor;
	TQPointArray            m_points;
public:
	virtual void draw(TQPainter & p);
	double scaleFactor(){ return m_dScaleFactor; };
	void setScaleFactor(double dScaleFactor);
	void resetPoints();
	const TQPointArray & internalPoints(){ return m_points; };
	void setInternalPoints(const TQPointArray &pnts);
	TQMap<TQString,TQVariant> * properties(){ return &m_properties; };
	virtual void setProperty(const TQString &property,const TQVariant &val);
	virtual int rtti() const;
};




class KviCanvasRectangleItem : public TQCanvasRectangle
{
	friend class KviCanvasRectangle;
	friend class KviCanvasRichText;
	friend class KviCanvasEllipticItem;
protected:
	KviCanvasRectangleItem(TQCanvas * c,int x,int y,int w,int h);
public:
	virtual ~KviCanvasRectangleItem();
protected:
	TQMap<TQString,TQVariant> m_properties;
public:
	int right(){ return ((int)x()) + width(); };
	int bottom(){ return ((int)y()) + height(); };
	TQMap<TQString,TQVariant> * properties(){ return &m_properties; };
	virtual void setProperty(const TQString &property,const TQVariant &val);
//	TQVariant property(const TQString &name){ return m_properties[name]; };
protected:
	void drawSelection(TQPainter &p);
};


class KviCanvasEllipticItem : public KviCanvasRectangleItem
{
	friend class KviCanvasEllipse;
	friend class KviCanvasChord;
	friend class KviCanvasPie;
protected:
	KviCanvasEllipticItem(TQCanvas * c,int x,int y,int w,int h);
	~KviCanvasEllipticItem();
public:
	virtual void setProperty(const TQString & property,const TQVariant &val);
	virtual void draw(TQPainter & p);
	virtual void drawContent(TQPainter & p);
	virtual int rtti() const;
};


class KviCanvasEllipse : public KviCanvasEllipticItem
{
public:
	KviCanvasEllipse(TQCanvas * c,int x,int y,int w,int h);
	~KviCanvasEllipse();
public:
	virtual void drawContent(TQPainter & p);
	virtual int rtti() const;
};


class KviCanvasPie : public KviCanvasEllipticItem
{
public:
	KviCanvasPie(TQCanvas * c,int x,int y,int w,int h);
	~KviCanvasPie();
public:
	virtual void drawContent(TQPainter & p);
	virtual int rtti() const;
};


class KviCanvasChord : public KviCanvasEllipticItem
{
public:
	KviCanvasChord(TQCanvas * c,int x,int y,int w,int h);
	~KviCanvasChord();
public:
	virtual void drawContent(TQPainter & p);
	virtual int rtti() const;
};


class KviCanvasLine : public TQCanvasLine
{
public:
	KviCanvasLine(TQCanvas * c,int x1,int y1,int x2,int y2);
	virtual ~KviCanvasLine();
protected:
	TQMap<TQString,TQVariant> m_properties;
public:
	TQMap<TQString,TQVariant> * properties(){ return &m_properties; };
	virtual void setProperty(const TQString &property,const TQVariant &val);
//	TQVariant property(const TQString &name){ return m_properties[name]; };
	virtual void draw(TQPainter & p);
	virtual int rtti() const;
};



class KviCanvasRectangle : public KviCanvasRectangleItem
{
public:
	KviCanvasRectangle(TQCanvas * c,int x,int y,int w,int h);
	~KviCanvasRectangle();
public:
	virtual void draw(TQPainter & p);
	virtual void setProperty(const TQString &property,const TQVariant &val);
	virtual int rtti() const;
};


class KviCanvasRichText : public KviCanvasRectangleItem
{
public:
	KviCanvasRichText(TQCanvas * c,int x,int y,int w,int h);
	~KviCanvasRichText();
public:
	virtual void draw(TQPainter & p);
	virtual int rtti() const;
};


class KviCanvasView : public TQCanvasView
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviCanvasView(TQCanvas * c,KviCanvasWidget * cw,TQWidget * par);
	~KviCanvasView();
public:
	enum State { Idle , SelectOrigin };
	enum ObjectType {
			Rectangle , RichText , Line , Ellipse , Chord , Pie ,
			PolygonTriangle , PolygonRectangle , PolygonPentagon ,
			PolygonHexagon
	};
	enum DragMode {
			None , All , Left , Right , Top , Bottom , LeftTop , RightTop ,
			LeftBottom , RightBottom , Scale , SinglePoint , Rotate
	};
protected:
	KviCanvasWidget * m_pCanvasWidget;

	// Insertion of objects
	State             m_state;
	ObjectType        m_objectToInsert;

	// Selected item
	TQCanvasItem   * m_pSelectedItem;

	DragMode          m_dragMode;
	TQPoint            m_dragBegin;
	double            m_dragScaleFactor;
	unsigned int      m_dragPointIndex;
	TQPointArray       m_dragPointArray;
protected:
	void beginDragRectangle(KviCanvasRectangleItem * it,const TQPoint &p,bool bInitial = false);
	void dragRectangle(KviCanvasRectangleItem * it,const TQPoint & p);

	void beginDragLine(KviCanvasLine * it,const TQPoint &p,bool bInitial = false);
	void dragLine(KviCanvasLine * it,const TQPoint &p);

	void beginDragPolygon(KviCanvasPolygon * it,const TQPoint &p,bool bShift = false,bool bCtrl = false);
	void dragPolygon(KviCanvasPolygon * it,const TQPoint &p);


	void setItemSelected(TQCanvasItem * it);
	void clearSelection();
	void insertObjectAt(const TQPoint & pnt,ObjectType o);
	virtual void contentsMousePressEvent(TQMouseEvent *e);
	virtual void contentsMouseMoveEvent(TQMouseEvent *e);
	virtual void contentsMouseReleaseEvent(TQMouseEvent *e);
public slots:
	void insertRectangle();
	void insertRichText();
	void insertLine();
	void insertPie();
	void insertChord();
	void insertEllipse();
	void insertPolygonTriangle();
	void insertPolygonRectangle();
	void insertPolygonPentagon();
	void insertPolygonHexagon();
	void propertyChanged(const TQString &s,const TQVariant &v);
};

// For TQt3.0 this might need to be changed

class KviVariantTableItem : public TQTableItem
{
public:
	KviVariantTableItem(TQTable * t,const TQVariant & property);
	~KviVariantTableItem();
private:
	TQVariant m_property;
public:
	virtual TQWidget *  createEditor() const;
	virtual void setContentFromEditor(TQWidget *w);
	TQVariant & property(){ return m_property; };
	virtual void paint(TQPainter *p,const TQColorGroup &cg,const TQRect &cr,bool selected);
};



class KviCanvasItemPropertiesWidget : public TQTable
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviCanvasItemPropertiesWidget(TQWidget * par);
	~KviCanvasItemPropertiesWidget();
public:
	void editItem(TQCanvasItem * it);
protected slots:
	void cellEdited(int row,int col);
signals:
	void propertyChanged(const TQString &s,const TQVariant &v);
};



class KviCanvasWidget : public TQWidget
{
	friend class KviCanvasView;
	Q_OBJECT
  TQ_OBJECT
public:
	KviCanvasWidget(TQWidget * par);
	~KviCanvasWidget();
protected:
	TQSplitter     * m_pSplitter;
	TQCanvas       * m_pCanvas;
	TQMenuBar      * m_pMenuBar;
	KviCanvasView * m_pCanvasView;
	TQLabel        * m_pStatusLabel;
	KviCanvasItemPropertiesWidget * m_pPropertiesWidget;
protected:
	virtual void resizeEvent(TQResizeEvent *);
};


#endif

#endif //_CANVAS_WIDGET_H_
