#ifndef _KVI_SELECTORS_H_
#define _KVI_SELECTORS_H_

//=============================================================================
//
//   File : kvi_selectors.h
//   Creation date : Mon Now 13 2000 15:21:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================


#include "kvi_settings.h"

#include <tqcheckbox.h>
#include "kvi_tal_hbox.h"
#include "kvi_tal_vbox.h"
#include <tqlineedit.h>
#include <tqlabel.h>
#include "kvi_tal_scrollview.h"
#include <tqpushbutton.h>
#include <tqcolor.h>
#include <tqfont.h>
#include "kvi_tal_listbox.h"
#include "kvi_tal_listview.h"
#include <tqspinbox.h>
#include <tqstringlist.h>
#include <tqvalidator.h>

#include "kvi_string.h"
#include "kvi_pixmap.h"
#include "kvi_styled_controls.h"

//#ifndef _KVI_SELECTORS_CPP_
//	extern void commitAllSelectors(TQWidget * par,const char * classname);
//#endif


//
// This is the common KviSelectorInterface
//
//     Note: I'm always learning
//           Today I have discovered that:
//              TQObject * o = new KviBoolSelector(...)
//              ((KviSelectorInterface *)o)->commit()
//           Does not work (SIGSEGV when jumping into commit(): bad vtable entry)
//           But the following works fine:
//              KviBoolSelector * b = new KviBoolSelector(...)
//              ((KviSelectorInterface *)b)->commit();
//           Mmmmmh.... the assembler generated by gcc
//           uses two different vtable offsets in the two cases
//           why ?
//

class KVIRC_API KviSelectorInterface
{
public:
	KviSelectorInterface(){};
	virtual ~KviSelectorInterface(){};
public:
	virtual void commit(){};
};

class KVIRC_API KviBoolSelector : public KviStyledCheckBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviBoolSelector(TQWidget * par,const TQString & txt,bool *pOption,bool bEnabled);
	~KviBoolSelector(){};
private:
	bool * m_pOption;
public:
	virtual void commit();
public slots:
	void setNotEnabled(bool bNotEnabled);
};

class KVIRC_API KviStringSelector : public KviTalHBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviStringSelector(TQWidget * par,const TQString & txt,TQString * pOption,bool bEnabled);
	~KviStringSelector();
protected:
	TQLabel    * m_pLabel;
	TQLineEdit * m_pLineEdit;
	TQString    * m_pOption;
public:
	void setValidator(TQValidator * v){ m_pLineEdit->setValidator(v); };
	void setMinimumLabelWidth(unsigned int uWidth){ m_pLabel->setMinimumWidth(uWidth); };
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
	void setText(const TQString& text);
};


class KVIRC_API KviPasswordSelector : public KviStringSelector
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviPasswordSelector(TQWidget * par,const TQString & txt,TQString * pOption,bool bEnabled);
	~KviPasswordSelector(){};
};

class KVIRC_API KviPixmapPreview : public KviTalScrollView
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviPixmapPreview(TQWidget * par);
	~KviPixmapPreview();
protected:
	KviPixmap * m_pPixmap;
public:
	void setPixmap(KviPixmap * pix);
protected:
	virtual void drawContents(TQPainter * p, int clipx, int clipy, int clipw, int cliph);

};

class KVIRC_API KviPixmapSelector : public TQWidget, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviPixmapSelector(TQWidget * par,const TQString & txt,KviPixmap * pOption,bool bEnabled);
	~KviPixmapSelector();
private:
	KviStyledCheckBox        * m_pCheckBox;
	TQLabel           * m_pFileNameLabel;
	KviPixmapPreview * m_pPreview;
	TQPushButton      * m_pChooseButton;
	KviPixmap        * m_pOption;
	KviPixmap          m_localPixmap;
public:
	void setImagePath(const char * path);
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
protected slots:
	void checkBoxToggled(bool bEnabled);
	void choosePixmap();
};

class KVIRC_API KviUIntSelector : public KviTalHBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviUIntSelector(TQWidget * par,const TQString & txt,unsigned int *pOption,
		unsigned int uLowBound,unsigned int uHighBound,unsigned int uDefault,bool bEnabled,bool bShortInt = false);
	~KviUIntSelector(){};
private:
	TQLabel    * m_pLabel;
	TQSpinBox  * m_pSpinBox;
	unsigned int * m_pOption;
	unsigned int m_uLowBound;
	unsigned int m_uHighBound;
	unsigned int m_uDefault;
	bool         m_bIsShortInt;
public:
	virtual void setPrefix(const TQString & txt);
	virtual void setSuffix(const TQString & txt);
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
};


class KVIRC_API KviFileSelector : public KviTalHBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviFileSelector(TQWidget * par,const TQString & txt,TQString * pOption,bool bEnabled,unsigned int uFlags = 0,const TQString &szFilter = TQString());
	~KviFileSelector(){};
public:
	enum Flags {
		ChooseSaveFileName = 1,
		DontConfirmOverwrite = 2
	};
protected:
	TQLabel      * m_pLabel;
	TQLineEdit   * m_pLineEdit;
	TQPushButton * m_pButton;
	TQString     * m_pOption;
	unsigned int  m_uFlags;
	TQString       m_szFilter;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
	void setSelection(const TQString &szSelection);
signals:
	void selectionChanged(const TQString &szNewValue);
private slots:
	void browseClicked();
protected:
	virtual void select();
};

class KVIRC_API KviDirectorySelector : public KviFileSelector
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviDirectorySelector(TQWidget * par,const TQString & txt,TQString * pOption,bool bEnabled);
	~KviDirectorySelector(){};
protected:
	virtual void select();
};


class KVIRC_API KviColorSelector : public KviTalHBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviColorSelector(TQWidget * par,const TQString & txt,TQColor * pOption,bool bEnabled);
	~KviColorSelector(){};
private:
	TQLabel      * m_pLabel;
	TQColor      * m_pOption;
	TQColor        m_memColor;
	TQPushButton * m_pButton;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
	TQColor getColor(){ return m_memColor; };
	void forceColor(TQColor clr);
private:
	void setButtonPalette(TQColor * pOption);
private slots:
	void changeClicked();
};

class KVIRC_API KviFontSelector : public KviTalHBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviFontSelector(TQWidget * par,const TQString & txt,TQFont * pOption,bool bEnabled);
	~KviFontSelector(){};
private:
	TQLabel      * m_pLabel;
	TQFont       * m_pOption;
	TQPushButton * m_pButton;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
private:
	void setButtonFont(TQFont * pOption);
private slots:
	void changeClicked();
};

class KVIRC_API KviStringListSelector : public KviTalVBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviStringListSelector(TQWidget * par,const TQString & txt,TQStringList * pOption,bool bEnabled);
	~KviStringListSelector();
private:
	TQLabel      * m_pLabel;
	KviTalListBox    * m_pListBox;
	TQLineEdit   * m_pLineEdit;
	TQPushButton * m_pAddButton;
	TQPushButton * m_pRemoveButton;
	TQStringList * m_pOption;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
private slots:
	void textChanged(const TQString &str);
	void selectionChanged();
	void addClicked();
	void removeClicked();
};

class KviTalPopupMenu;

class KVIRC_API KviMircTextColorSelector : public KviTalHBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviMircTextColorSelector(TQWidget * par,const TQString &txt,unsigned int * uFore,unsigned int * uBack,bool bEnabled);
	~KviMircTextColorSelector();
private:
	TQLabel *m_pLabel;
	TQPushButton * m_pButton;
	unsigned int * m_pUFore;
	unsigned int * m_pUBack;
	unsigned int m_uFore;
	unsigned int m_uBack;
	KviTalPopupMenu * m_pContextPopup;
	KviTalPopupMenu * m_pForePopup;
	KviTalPopupMenu * m_pBackPopup;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
protected slots:
	void buttonClicked();
	void foreSelected(int);
	void backSelected(int);
protected:
	void setButtonPalette();
};


class KVIRC_API KviSoundSelector : public KviFileSelector
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviSoundSelector(TQWidget * par,const TQString & txt,TQString * pOption,bool bEnabled);
	~KviSoundSelector();
protected:
	TQPushButton	*m_pPlayButton;
private slots:
	void playSound();
public:
	virtual void setEnabled(bool bEnabled);
};

class KVIRC_API KviChanListViewItem : public KviTalListViewItem
{
private:
	TQString m_szPass;
public:
	KviChanListViewItem(KviTalListView* pList,TQString szChan,TQString szPass);
	~KviChanListViewItem() {};
	
	const TQString& pass() { return m_szPass; }
};

class KVIRC_API KviCahnnelListSelector : public KviTalVBox, public KviSelectorInterface
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviCahnnelListSelector(TQWidget * par,const TQString & txt,TQStringList * pOption,bool bEnabled);
	~KviCahnnelListSelector();
private:
	TQLabel       * m_pLabel;
	KviTalListView    * m_pListView;
	TQLineEdit    * m_pChanLineEdit;
	TQLineEdit    * m_pPassLineEdit;
	TQPushButton  * m_pAddButton;
	TQPushButton  * m_pRemoveButton;
	TQStringList  * m_pOption;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
private slots:
	void textChanged(const TQString &str);
	void selectionChanged();
	void addClicked();
	void removeClicked();
};



#endif //!_KVI_SELECTORS_H_
