#ifndef _KVI_LISTVIEW_H_
#define _KVI_LISTVIEW_H_

///////////////////////////////////////////////////////////////////////////////
//
//   File : kvi_listview.h
//   Creation date : 19  Jan 2006 GMT by Alexey Uzhva
//
//   This toolbar is part of the KVirc irc client distribution
//   Copyright (C) 2006 Alexey Uzhva
//   Copyright (C) 2006 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
///////////////////////////////////////////////////////////////////////////////

#include "kvi_heapobject.h"

#include "kvi_tal_listview.h"

class TQPainter;

class KVIRC_API KviListView : public KviTalListView
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviListView( TQWidget * parent = 0, const char * name = 0);
	~KviListView();
protected:
	TQPixmap      * m_pBackgroundOverlayPixmap;
	int            m_iBackgroundOverlayAlignment;
public:
	virtual void setBackgroundOverlayPixmap(TQPixmap* pix,int iAlignmentFlags = TQt::AlignAuto);
public:
	void publicUpdateContents(){ updateContents(); }; // <-- unscrewContents(); :D
protected:
	virtual void paintEmptyArea(TQPainter * p, const TQRect & rect );
	virtual void drawContentsOffset(TQPainter * p,int ox,int oy,int cx,int cy,int cw,int ch);
	virtual void resizeEvent(TQResizeEvent * e);
#ifdef COMPILE_ON_WINDOWS
	virtual void focusInEvent(TQFocusEvent * e);
	virtual void focusOutEvent(TQFocusEvent * e);
#endif
};

#endif //!_KVI_LISTVIEW_H_
