#ifndef _KVI_CTCPPAGEDIALOG_H_
#define _KVI_CTCPPAGEDIALOG_H_
//
//   File : kvi_ctcppagedialog.h
//   Creation date : Tue May 21 2002 22:09:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"

#include "kvi_string.h"

#include "kvi_tal_widgetstack.h"
#include <tqtabbar.h>
#include <tqwidget.h>
#include <tqpushbutton.h>

class KVIRC_API KviCtcpPageDialog : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviCtcpPageDialog();
	~KviCtcpPageDialog();
protected:
	KviTalWidgetStack * m_pWidgetStack;
	TQTabBar      * m_pTabBar;
	TQPushButton  * m_pCloseButton;
public:
	void popup();
	void addPage(const TQString &szNick,const TQString &szUser,const TQString &szHost,const TQString &szMsg);
protected slots:
	void tabSelected(int id);
	void die();
protected:
	void center();
	virtual void showEvent(TQShowEvent *e);
	virtual void closeEvent(TQCloseEvent *);
};

#endif //_KVI_CTCPPAGEDIALOG_H_
