/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef COLORCOMBO_H
#define COLORCOMBO_H

#include <tqcolor.h>
#include <tqcombobox.h>

/**
Based on KColorCombo, Copyright (C) 1997 Martin Jones (mjones@kde.org). Allows
which colours are displayed to be changed.

@author David Saxton
*/
class ColorCombo : public TQComboBox
{
	Q_OBJECT
  TQ_OBJECT
	TQ_PROPERTY( TQColor color READ color WRITE setColor )

	public:
		enum ColorScheme
		{
			TQtStandard = 0,
			LED = 1,
			NumberOfSchemes = 2, ///< for internal usage; this should be one less than the number of items in the enum
		};
		
  	 	/**
		 * Constructs a color combo box.
		 */
		ColorCombo( ColorScheme colorScheme, TQWidget *parent, const char *name = 0L );
		~ColorCombo();

		/**
		 * Selects the color @p col.
		 */
		void setColor( const TQColor & col );
		/**
		 * Returns the currently selected color.
		**/
		TQColor color() const { return internalColor; }

	signals:
    	/**
		 * Emitted when a new color box has been selected.
		 */
		void activated( const TQColor &col );
	    /**
		 * Emitted when a new item has been highlighted.
		 */
		void highlighted( const TQColor &col );
		
	protected slots:
		void slotActivated( int index );
		void slotHighlighted( int index );

	protected:
		virtual void resizeEvent( TQResizeEvent *re );
		void addColors();
		void createPalettes();
		
		TQColor customColor;
		TQColor internalColor;
		ColorScheme m_colorScheme;
		
		static bool createdPalettes;
		static TQColor * palette[ NumberOfSchemes ];
		static int paletteSize[ NumberOfSchemes ];
};

#endif
