/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef LOG_LIST_ITEM_H
#define LOG_LIST_ITEM_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqpixmap.h>
#include <tqmap.h>
#include <tqregexp.h>

#include <kiconloader.h>
#include <kurl.h>
#include <klistview.h>

#include "globals.h"

#include "logLine.h"


class LogLine;
class LogMode;
class XorgLogLine;



/**
 * @author Nicolas Ternisien
 */
class LogListItem : public KListViewItem {
	
	public:
		LogListItem(TQListView* list, LogLine* l);
		
		LogListItem(TQListViewItem* parent, LogLine* l);

		~LogListItem();
		
		TQDateTime& getTime();
		
		virtual int compare(TQListViewItem * i, int col, bool ascending) const;
		
		TQString getFormattedText();
		TQString getToolTipText();
		
		LogLine* getLogLine();
		
		virtual void paintCell(TQPainter* p, const TQColorGroup &cg, int column, int width, int align);
		
		TQString exportToText();
		
	protected:
		LogLine* line;

};

#endif //LOG_LIST_ITEM_H
