/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include "loadingDialog.h"

LoadingDialog::LoadingDialog(TQWidget* parent, const char* name, bool modal) :
	KProgressDialog(parent, name, i18n("Loading Progress"), "", modal),
	tabCount(0),
	currentTab(0),
	
	fileCount(0),
	currentFile(0),
	
	firstLoading(false)
	{
	

	//TODO Try to find a better solution (if it exists!)
	resize(380, 110);

}


LoadingDialog::~LoadingDialog() {


}


bool LoadingDialog::isFirstLoading() {
	return(firstLoading);
}

void LoadingDialog::setFirstLoading(bool first) {
	firstLoading=first;
}


int LoadingDialog::getTabCount() {
	return(tabCount);
}

void LoadingDialog::setTabCount(int count) {
	this->tabCount=count;
	
	if (tabCount==0)
		hide();
	else
		show();
}

int LoadingDialog::getFileCount() {
	return(fileCount);
}

void LoadingDialog::setFileCount(int count) {
	this->fileCount=count;
}

int LoadingDialog::getCurrentFile() {
	return(currentFile);
}


void LoadingDialog::setCurrentFile(int current) {
	this->currentFile=current;
}

int LoadingDialog::getCurrentTab() {
	return(currentTab);
}


void LoadingDialog::setCurrentTab(int current) {
	this->currentTab=current;
}

void LoadingDialog::hide() {
	
	//Only hide the Loading Dialog if there is only one Log Manager to load
	if (tabCount<=1) {
		KProgressDialog::hide();
	}
}

void LoadingDialog::setLoadingLog(const TQString& text) {
	//Several files to load
	if (fileCount>1 && currentFile>=1) {
		//Several tabs to load
		if (tabCount>1 && currentTab>=1) {
			if (firstLoading)
				setLabel(i18n("<qt>Loading <b>%1</b> [<b>%2</b>/%3 file] (<b>%4</b>/%5)...</qt>").arg(text).arg(currentFile).arg(fileCount).arg(currentTab).arg(tabCount));
			else
				setLabel(i18n("<qt>Reloading <b>%1</b> [<b>%2</b>/%3 file] (<b>%4</b>/%5)...</qt>").arg(text).arg(currentFile).arg(fileCount).arg(currentTab).arg(tabCount));
		}
		//Only one tab to load
		else {
			if (firstLoading)
				setLabel(i18n("<qt>Loading <b>%1</b> [<b>%2</b>/%3 file]...</qt>").arg(text).arg(currentFile).arg(fileCount));
			else
				setLabel(i18n("<qt>Reloading <b>%1</b> [<b>%2</b>/%3 file]...</qt>").arg(text).arg(currentFile).arg(fileCount));
		}
	
	}
	//Only one file
	else {
		//Several tabs to load
		if (tabCount>1 && currentTab>=1) {
			if (firstLoading)
				setLabel(i18n("<qt>Loading <b>%1</b> (<b>%2</b>/%3)...</qt>").arg(text).arg(currentTab).arg(tabCount));
			else
				setLabel(i18n("<qt>Reloading <b>%1</b> (<b>%2</b>/%3)...</qt>").arg(text).arg(currentTab).arg(tabCount));
		}
		//Only one tab to load
		else {
			if (firstLoading)
				setLabel(i18n("<qt>Loading <b>%1</b>...</qt>").arg(text));
			else
				setLabel(i18n("<qt>Reloading <b>%1</b>...</qt>").arg(text));
		}
	}
	
}


#include "loadingDialog.moc"
