/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

//TQt includes
#include <tqlayout.h>
#include <tqvgroupbox.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>

//KDE includes
#include <klocale.h>
#include <kactioncollection.h>
#include <kbuttonbox.h>
#include <klistbox.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "kernelOptions.h"
#include "ksystemlogConfig.h"

KernelOptions::KernelOptions(TQWidget *parent) : 
	TQWidget(parent)
	{
	
	TQHBoxLayout *layout = new TQHBoxLayout(this);
	layout->setAutoAdd(true);

	TQString description= i18n("<qt><p>These files will be analyzed to display <b>Kernel logs</b>. This list also determines the order in which the files are read.</p></qt>");
	fileList=new SpecificFileList(this, description);
	
	connect(fileList, TQT_SIGNAL(fileListChanged(int)), this, TQT_SLOT(slotFileListChanged(int)));

	readConfig();
	

}

KernelOptions::~KernelOptions() {
	
}

bool KernelOptions::isValid() {
	if (fileList->count()>0)
		return(true);
	else
		return(false);
}

void KernelOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void KernelOptions::saveConfig() {
	kdDebug() << "Saving config from Kernel Options..." << endl;
	
	TQStringList stringList;
	TQValueList<int> valueList;
		
	fileList->saveConfig(stringList, valueList);
	
	KSystemLogConfig::setKernelPaths(stringList);
	KSystemLogConfig::setKernelLevels(valueList);
}

void KernelOptions::readConfig() {
	TQStringList stringList=KSystemLogConfig::kernelPaths();
	TQValueList<int> valueList=KSystemLogConfig::kernelLevels();
	
	fileList->readConfig(stringList, valueList);
}

#include "kernelOptions.moc"
