/***************************************************************************
                          sq_glwidget_helpers.h  -  description
                             -------------------
    begin                : May 31 2005
    copyright            : (C) 2005 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_GLWIDGET_HELPERS
#define SQ_GLWIDGET_HELPERS

#include <ktoolbarbutton.h>

class TQWMatrix;

class KToolBar;

struct RGBA;

class SQ_ToolButtonPopup : public KToolBarButton
{
    public:
        SQ_ToolButtonPopup(const TQPixmap &pix, const TQString &textLabel, KToolBar *parent);
        ~SQ_ToolButtonPopup();
};

class SQ_ToolButton : public TQToolButton
{
    public:
        SQ_ToolButton(const TQIconSet &iconSet, const TQString &textLabel, TQObject *receiver,
                        const char *slot, KToolBar *parent, const char *name = 0);
        ~SQ_ToolButton();

        static int fixedWidth();
};

inline
int SQ_ToolButton::fixedWidth()
{
    return 26;
}

namespace SQ_GLHelpers
{
    //                                                                               0, 1, 2
    typedef void (* scanLineGetter)(RGBA *data, RGBA *, int rw, int w, int h, int y, int flip);

    void scanLine0(RGBA *, RGBA *, int, int, int, int, int);
    void scanLine90(RGBA *, RGBA *, int, int, int, int, int);
    void scanLine180(RGBA *, RGBA *, int, int, int, int, int);
    void scanLine270(RGBA *, RGBA *, int, int, int, int, int);

    int roundAngle(int ang);

    void subRotation(TQWMatrix &wm, int curangle, int orient);

    /*
     * normalize selection rectangle
     * sx,sy are X and Y coordinates
     * sw x sh is a selection geometry
     */
    bool normalizeSelection(int &sx, int &sy, int &sw, int &sh, int w, int h, const TQWMatrix&, int curangle, int orient);
}

#endif
