/***************************************************************************
                          sq_bookmarkowner.h  -  description
                             -------------------
    begin                : ??? ??? 27 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_BOOKMARKOWNER_H
#define SQ_BOOKMARKOWNER_H

#include <kbookmarkmanager.h>
#include <kurl.h>

#include <tqobject.h>
#include <tqwidget.h>

/*
 *  Class for managing bookmarks. It used in main class (KSquirrel::initBookmarks())
 *  and in SQ_WidgetStack to store and manage bookmarks.
 */

class SQ_BookmarkOwner : public TQObject, public KBookmarkOwner
{
    Q_OBJECT
  TQ_OBJECT

    public: 
        SQ_BookmarkOwner(TQWidget *parent = 0);
        virtual ~SQ_BookmarkOwner();

        /*
         *  User selected some bookmark. It will emit 'openURL' signal,
         *  and SQ_WidgetStack will catch it.
         */
        virtual void openBookmarkURL(const TQString &);

        /*
         *  Current url. If user selected "Add bookmark", this
         *  url will be added to bookmarks. See also SQ_BookmarkOwner::setURL()
         */
        virtual TQString currentURL() const;
    
        static SQ_BookmarkOwner* instance() { return m_instance; }

        /*
         *  Set current url
         */
    public slots:
        void setURL(const KURL &);

        /*
         *  Signal to open some url. SQ_WidgetStack will catch it
         *  and change current directory.
         */
    signals:
        void openURL(const KURL &);

    private:
        KURL URL;

        // singleton
        static SQ_BookmarkOwner *m_instance;
};

#endif
