/***************************************************************************
                          sq_multibar.h  -  description
                             -------------------
    begin                : ??? Nov 28 2005
    copyright            : (C) 2005 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_MULTIBAR_H
#define SQ_MULTIBAR_H

#include <tqhbox.h>

class KMultiTabBar;

class TQWidgetStack;
class TQSignalMapper;

/*
 *  Konqueror-like sidebar.
 *
 *    +----------------------------------> KMultiTabBar, only contains buttons
 *    |           +-----------------+
 *    |           |                 |
 *    |           |                 |
 *  +------------------------+      |
 *  | 1 |                    |      +----> TQWidgetStack, contains all widgets
 *  |---|                    |
 *  | 2 |                    |
 *  |---|                    |
 *  | 3 |                    |
 *  |---|                    |
 *  |   |    visible page    |
 *  |   |                    |
 *  | 4 |        N4          |
 *  |   |                    |
 *  |   |                    |
 *  |---|                    |
 *  |   |                    |
 *  |   |                    |
 *  |   |                    |
 *  |   |                    |
 *  +------------------------+
 *
 */

class SQ_MultiBar : public TQHBox
{
    Q_OBJECT
  TQ_OBJECT

    public: 
        SQ_MultiBar(TQWidget *parent = 0, const char *name = 0);
	 ~SQ_MultiBar();

        /*
         *  Add new widget with text label 'text' and icon 'icon'. SQ_MultiBar
         *  will use SQ_IconLoader to load given icon.
         */
        void addWidget(TQWidget *new_w, const TQString &text, const TQString &icon);

        /*
         *  Current page index. 0 means first page.
         */
        int currentPage();

        void updateLayout();

        KMultiTabBar* multiBar() const;

        static SQ_MultiBar* instance() { return m_inst; }

    public slots:

        /*
         *  Hide current widget and show a widget with
         *  id 'id'.
         */
        void raiseWidget(int id);

    private:
        KMultiTabBar *mt;
        TQWidgetStack *stack;
        int m_id, m_selected, m_width;
        TQSignalMapper *mapper;

        static SQ_MultiBar *m_inst;
};

inline
int SQ_MultiBar::currentPage()
{
    return m_selected;
}

inline
KMultiTabBar* SQ_MultiBar::multiBar() const
{
    return mt;
}

#endif
