/***************************************************************************
                          sq_multibar.cpp  -  description
                             -------------------
    begin                : ??? Nov 28 2005
    copyright            : (C) 2005 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqwidgetstack.h>
#include <tqsignalmapper.h>
#include <tqsplitter.h>

#include <kmultitabbar.h>
#include <kglobal.h>
#include <kiconloader.h>

#include "ksquirrel.h"
#include "sq_previewwidget.h"
#include "sq_multibar.h"
#include "sq_config.h"

SQ_MultiBar * SQ_MultiBar::m_inst = 0;

SQ_MultiBar::SQ_MultiBar(TQWidget *parent, const char *name) : TQHBox(parent, name)
{
    m_inst = this;
    m_id = 0;
    m_selected = -1;

    SQ_Config::instance()->setGroup("Interface");
    m_width = SQ_Config::instance()->readNumEntry("splitter", 220);

    mapper = new TQSignalMapper(TQT_TQOBJECT(this));

    connect(mapper, TQT_SIGNAL(mapped(int)), this, TQT_SLOT(raiseWidget(int)));

    mt = new KMultiTabBar(KMultiTabBar::Vertical, this);

    // setup multibar: style = VSNET, show text labels on the left side
    mt->setStyle(KMultiTabBar::VSNET);
    mt->setPosition(KMultiTabBar::Left);
    mt->showActiveTabTexts(true);

    setSpacing(0);

    TQSplitter   *ts = new TQSplitter(Qt::Vertical, this);
    ts->setOpaqueResize(false);

    // TQWigdetStack will contain all widgets
    stack = new TQWidgetStack(ts);

    new SQ_PreviewWidget(ts);

    TQValueList<int> sz;
    sz.append(5500);
    sz.append(4500);
    ts->setSizes(sz);
}

SQ_MultiBar::~SQ_MultiBar()
{}

void SQ_MultiBar::addWidget(TQWidget *new_w, const TQString &text, const TQString &icon)
{
    // add widget to stack
    stack->addWidget(new_w, m_id);

    // add button
    mt->appendTab(KGlobal::iconLoader()->loadIcon(icon, KIcon::Desktop, 22), m_id, text);

    // since we cann't determine which tab was clicked,
    // we should use TQSignalMapper to determine it.
    mapper->setMapping(TQT_TQOBJECT(mt->tab(m_id)), m_id);

    connect(mt->tab(m_id), TQT_SIGNAL(clicked()), mapper, TQT_SLOT(map()));

    m_id++;
}

void SQ_MultiBar::raiseWidget(int id)
{
    if(m_selected != -1)
        mt->setTab(m_selected, false);

    if(mt->isTabRaised(id))
    {
        if(m_selected != -1)
            m_width = stack->width();

        m_selected = id;

        setMinimumSize(TQSize(0, 0));
        setMaximumSize(TQSize(10000, 10000));
        stack->raiseWidget(id);
        stack->resize(m_width, stack->height());
        stack->show();

        SQ_PreviewWidget::instance()->ignore(false);
        SQ_PreviewWidget::instance()->loadPending();
    }
    else
    {
        SQ_PreviewWidget::instance()->ignore(true);

        KSquirrel::app()->saveLayout();

        m_selected = -1;
        m_width = stack->width();
        stack->hide();
        setFixedWidth(mt->width());
    }
}

void SQ_MultiBar::updateLayout()
{
    setFixedWidth(mt->sizeHint().width());
    stack->hide();
}

#include "sq_multibar.moc"
