/***************************************************************************
                          myinputdialog.h  -  description
                             -------------------
    begin                : Mit Apr 01 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYINPUTDIALOG_H
#define MYINPUTDIALOG_H

#include <tqdialog.h>

class TQVBoxLayout;
class TQHBoxLayout; 
class TQGridLayout; 
class KLineEdit;
class KPushButton;
class TQLabel;
class TQString;
class MyInputDialog : public TQDialog
{ 
    Q_OBJECT
  TQ_OBJECT
    public:
        MyInputDialog( TQString filename, bool revertEnabled = true, TQWidget* parent = 0 );
        ~MyInputDialog();

        TQString filename() const;
        inline void setInputFilename( const TQString s );

        enum returnCodes {
            OK,
            CANCEL,
            USE_KRENAME
        };

    private slots:
        /** Use the file name generated by KRename....
         */
        void krename(); // ????? :-)
        void slotFilename();
        void accept();
        void reject();

    private:
        TQLabel* TextLabel1;
        KLineEdit* text;
        KPushButton* buttonKrename;
        KPushButton* buttonFilename;
        KPushButton* buttonOk;
        KPushButton* buttonCancel;

        TQString m_oldfilename;

    protected:
        TQVBoxLayout* MyInputDialogLayout;
        TQHBoxLayout* Layout;
};

void MyInputDialog::setInputFilename( const TQString s )
{
    m_oldfilename = s;
}

#endif // MYINPUTDIALOG_H
