/***************************************************************************
                          kmyhistorycombo.cpp  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT includes
#include <tqlistbox.h>

// Own includes
#include "kmyhistorycombo.h"

#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>

#include <tqpopupmenu.h>
#include <tqtimer.h>

#define TIMER_DELAY 500

#define KRENAME_FILENAME       5000
#define KRENAME_FILENAME_LOWER 5001
#define KRENAME_FILENAME_UPPER 5002
#define KRENAME_NUMBER         5003
#define KRENAME_DATE           5004

KMyHistoryCombo::KMyHistoryCombo( bool customPopup, TQWidget* parent, const char* name)
    : KHistoryCombo(parent, name)
{
    TQStringList history;
    TQStringList completion;
    KConfig* config = kapp->config();
    config->setGroup( name );
    this->setDuplicatesEnabled( false );
    
    history = config->readListEntry("History");
    completion = config->readListEntry("CompletionItems");
    m_timer = new TQTimer();
    
    setHistoryItems( history );

    completionObject()->setItems( ( completion.isEmpty() ? history : completion ) );
    setCompletionMode( (KGlobalSettings::Completion)config->readNumEntry( "CompletionMode",
                        KGlobalSettings::completionMode() ) );    
                        
    connect( this, TQT_SIGNAL( textChanged( const TQString & ) ), this, TQT_SLOT( textChangedGovernor() ) );
    connect( m_timer, TQT_SIGNAL( timeout() ), this, TQT_SIGNAL( delayedTextChanged() ) );

    if( customPopup )
        connect( this, TQT_SIGNAL( aboutToShowContextMenu( TQPopupMenu* ) ), this, TQT_SLOT( slotCustomContextMenu( TQPopupMenu* ) ) );
}

KMyHistoryCombo::~KMyHistoryCombo()
{
    delete m_timer;
}

void KMyHistoryCombo::saveSettings()
{
    addToHistory( text() );

    KConfig* config = kapp->config();
    
    config->setGroup( name() ? name() : "KMyHistoryCombo" );
    config->writeEntry( "History", historyItems() );
    config->writeEntry( "CompletionItems", completionObject()->items() );
    config->writeEntry( "CompletionMode", completionMode() );

    config->sync();
}

TQString KMyHistoryCombo::text( int index ) const 
{
    return this->listBox()->text( index );
}

void KMyHistoryCombo::setText( const TQString & text )
{
    this->lineEdit()->setText( text );
}

void KMyHistoryCombo::add( const TQString & text )
{
    int i;
    for ( i = 0; i < this->count(); i++ )
        if( this->text( i ) == text ) {
            TQString tmp = this->text( i );
            this->listBox()->removeItem( i );
            this->insertItem( tmp, 0 );
            return;
        }

    if( this->count() == this->maxCount() )
        this->listBox()->removeItem( this->maxCount() );

    this->insertItem( text, 0 );
}

bool KMyHistoryCombo::isEmpty() const
{
    return this->lineEdit()->text().isEmpty();
}

void KMyHistoryCombo::textChangedGovernor()
{
    m_timer->stop();
    m_timer->start( TIMER_DELAY, true );
}

void KMyHistoryCombo::slotCustomContextMenu( TQPopupMenu* p )
{
    TQPopupMenu* krename = new TQPopupMenu( p );
    krename->insertItem( i18n("&Filename"), KRENAME_FILENAME );
    krename->insertItem( i18n("Filename to &lowercase"), KRENAME_FILENAME_LOWER );
    krename->insertItem( i18n("Filename to &uppercase"), KRENAME_FILENAME_UPPER );
    krename->insertItem( i18n("&Number"), KRENAME_NUMBER );
    krename->insertItem( i18n("&Date"), KRENAME_DATE );

    connect( krename, TQT_SIGNAL( activated( int ) ), this, TQT_SLOT( slotInsertKRenameCommand( int ) ) );

    p->insertSeparator( 0 );
    p->insertItem( i18n("Insert &KRename token"), krename, 0, 0 );
}

void KMyHistoryCombo::slotInsertKRenameCommand( int id )
{
    TQString t;

    // TODO:
    // also use constants for KRename tokens!

    switch( id )
    {
        case KRENAME_FILENAME:
            t = "$";
            break;
        case KRENAME_FILENAME_LOWER:
            t = "%";
            break;
        case KRENAME_FILENAME_UPPER:
            t = "&";
            break;
        case KRENAME_NUMBER:
            t = "#";
            break;
        case KRENAME_DATE:
            t = "[date]";
            break;
        default:
            break;
    }

    if( !t.isEmpty() )
        this->lineEdit()->insert( t );
}
