/***************************************************************************
                          confdialog.cpp  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "confdialog.h"

// QT includes
#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqtooltip.h>

// KDE includes
#include <kiconloader.h>
#include <klocale.h>

ConfDialog::ConfDialog( TQWidget* parent, const char* name )
    :  KDialogBase( KDialogBase::IconList, "KRename",
       KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Default, KDialogBase::Ok, parent, name, true, true ),
       GUIModeSelector()
{
    setupTab1();
    setupTab2();

    connect( this, TQT_SIGNAL( defaultClicked() ), this, TQT_SLOT( defaults() ) );
}

ConfDialog::~ConfDialog()
{
}

void ConfDialog::setupTab1()
{
    const TQString caption = i18n("Look and Feel");
    TQFrame* box = addPage( caption, caption, BarIcon("looknfeel") );
    TQVBoxLayout* layout = new TQVBoxLayout( box );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    TQButtonGroup* group = new TQButtonGroup( box );
    group->setColumnLayout(0, Qt::Vertical );
    TQVBoxLayout* lgroup = new TQVBoxLayout( group->layout() );

    optionWizard = new TQRadioButton( group );
    optionWizard->setText( i18n("Use &wizard style GUI (beginners)") );
    optionTabs = new TQRadioButton( group );
    optionTabs->setText( i18n("Use &tabbed GUI (advanced users)") );

    lgroup->addWidget( new TQLabel( i18n("Configure the look and feel of the KRename GUI:<br>"), group ) );
    lgroup->addWidget( optionWizard );
    lgroup->addWidget( optionTabs );
    lgroup->addItem( spacer );
        
    layout->addWidget( group );
    layout->addItem( spacer );
}

void ConfDialog::setupTab2()
{
    const TQString caption = i18n("KRename");
    TQFrame* box = addPage( caption, caption, BarIcon("krename") );
    TQVBoxLayout* layout = new TQVBoxLayout( box );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    checkPlugins = new TQCheckBox( i18n("&Load file plugins on start"), box );
    checkAutosize = new TQCheckBox( i18n("Auto &resize columns in preview"), box );

    spinSize = new KIntNumInput( box );
    spinSize->setRange( 20, 500, 1, false );
    spinSize->setLabel( i18n( "&Thumbnail size:" ), AlignLeft | AlignVCenter );

    spinHistory = new KIntNumInput( box );
    spinHistory->setRange( 2, 500, 1, false );
    spinHistory->setLabel( i18n( "&Number of template history items:" ), AlignLeft | AlignVCenter );

    layout->addWidget( checkPlugins );
    layout->addWidget( checkAutosize );
    layout->addItem( spacer );
    layout->addWidget( spinSize );
    layout->addWidget( spinHistory );
    layout->addItem( spacer );

    TQToolTip::add( checkPlugins, i18n("Disabling this option decreases KRename's startup time, because no KFilePlugins are loaded.") );
}

void ConfDialog::defaults()
{
    checkPlugins->setChecked( true );
    checkAutosize->setChecked( false );

    optionWizard->setChecked( true );

    spinSize->setValue( 80 );
}

