/***************************************************************************
                          batchrenamer.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCHRENAMER_H
#define BATCHRENAMER_H

#include <tqdatetime.h>
#include <tqvaluelist.h>
#include <kurl.h>

class TQFile;
class TQProgressDialog;
class TQString;

/* How many diferrent users and groups
 * KRename supports. Values over 1000
 * make KRename slow, but it may be
 * necessary on bigger systems to
 * increase this value.
 * MAXENTRIES must be < sizeof(int)
 */
#define MAXENTRIES 1000

/* May Value for SpinBoxes
 *
 */
#define SPINMAX 100000

enum {
    COPY, MOVE, RENAME, PREVIEW, LINK
};

typedef struct fileentry {
    TQString name;       // filename
    TQString directory;  // directory
    TQString extension;  // extension

    KURL url;
};

typedef struct data {
    fileentry src;
    fileentry dst;

    bool dir;
};

/*
 * Changes made by hand by the user
 * in the preview list view are
 * stored here.
 */
typedef struct manualchanges {
    KURL url;      // input filename
    TQString user;  // name the user wants
};

typedef struct replacestrings {
    TQString find;      // Text to replace
    TQString replace;   // Replace with
    bool reg;          // is it a reg expression ?
};

typedef struct tCounterValues {
    int value;  // current value of this counter
    int start;  // start value of this counter (for findResetCounter)
    int step;   // stepping value of this counter;
};

/**
  *@author Dominik Seichter
  */

class TQObject;
class TQListView;
class ProgressDialog;
class PluginLoader;
class BatchRenamer {
    public:
        BatchRenamer();
        ~BatchRenamer();
        void processFiles( ProgressDialog* p, TQObject* object );
        void createPreview( TQListView* list );

        inline void setText( const TQString & t ) { text = t; doEscape( text, false ); }
        inline void setExText( const TQString & t ) { extext = t; }
        inline void setDirname( const KURL & url ) { dirname = url; }
        inline void setUndoScript( const TQString & t ) { m_undoScript = t; }
        inline void setUndo( bool b ) { undo = b; }
        inline void setOverwrite( bool b ) { overwrite = b; }
        inline void setIndex( int i ) { m_index = i; }
        inline void setStep( int s ) { m_step = s; }
	inline void setResetCounter( bool r ) { m_reset = r; }
        inline void setSkipList( const TQValueList<int> & s ) { m_skip = s; }
        inline void setReplaceList( const TQValueList<replacestrings> & r ) { m_replace = r; }
        
        inline void setFiles( const TQValueList<data> & f ) { m_files = f; } //TODO: use a pointer for more speed
        inline TQValueList<data> files() const { return m_files; }
        inline void setChanges( const TQValueList<manualchanges> & m ) { m_changes = m; }

        inline void setMode( int m) { m_mode = m; }
        inline int mode() const { return m_mode; }

        // Since 2.1 public, because plugins may want to access them to:
        TQString findAndProcess( const TQString & token, TQString text, const TQString & replace );

        TQString findNumbers( TQString text, int count, int i );
        TQString findStar( const TQString & oldname, TQString text );
        TQString findBrackets( TQString oldname, TQString text, int i );
        TQString findToken( TQString oldname, TQString token, int i );
        TQString processToken( TQString token, TQString oldname, int i );
        TQString findPartStrings( TQString oldname, TQString token );
        static TQString findDirName( TQString token, TQString path );
        TQString findLength( const TQString & token, const TQString & name );
        TQString findReplace( TQString text );  // text is here already the new filename !
        TQString doReplace( TQString text, TQString find, TQString replace, bool reg ); // text is here already the new filename !

        TQString processString( TQString text, TQString oldname, int i );
        
        static TQString & doEscape( TQString text, bool filename = true );
        static TQString & unEscape( TQString & text );
        static void escape( TQString & text, const TQString & token, const TQString & sequence );

        static TQString buildFilename( fileentry* entry, bool dir = true );

    private:
        /** 
         * Returns the length of the string when int n is converted to
         * a string.
         * @param n   a number whose length as string is needed
         * @returns stringlength of n converted to a string 
         */
        int getCharacters( int n ) ;

        void work( ProgressDialog* p );
        void writeUndoScript( TQTextStream* t );
        void parseSubdirs( data* f );
        void findNumberAppendix( TQString & text, int pos, int* start, int* step );
	/** resets all counters to there start value if the directory name at @p i
	 *  in m_files changes.
	 *  The caller has to check m_reset before calling this function.
	 */
        void findCounterReset( int i );
        TQString parsePlugins( int i, const TQString & text, int type );
        bool applyManualChanges( int i );

        TQString text;           // template
        KURL dirname;           // destination dir
        TQString extext;         // Extension template
        TQString m_undoScript;     // Filename of undoscript
        bool undo;              // create an undo script
        int m_index;              // index for numbers
        int m_step;               // step for numbers
	bool m_reset;             // reset counter on new directories
        bool overwrite;         // overwrite existing files
        int m_mode;             // renaming mode
        TQValueList<int> m_skip; // Numbers to skip
        TQValueList<replacestrings> m_replace; // Replace strings
        TQValueList<data> m_files;
        TQValueList<manualchanges> m_changes;  // User made changes
        PluginLoader* plug;

        // a is used in find number and
        // required for skipping.
        int m_counter_index;
	TQValueList<tCounterValues> m_counters;
        
    protected:
        TQFile* f;
        TQTime t;
        TQProgressDialog* progress;
};

#endif
