/***************************************************************************
                          StationSelector.h  -  description
                             -------------------
    begin                : Son Aug 3 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_STATIONSELECTOR_H
#define KRADIO_STATIONSELECTOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstringlist.h>

#include "radio_interfaces.h"
#include "stationselection_interfaces.h"
#include "stationlist.h"

#include <stationselector-ui.h>
#include "radiostation-listview.h"


class RadioStationListView;

class StationSelector : public StationSelectorUI,
                        public IRadioClient,
                        public IStationSelectionClient
{
Q_OBJECT
  TQ_OBJECT
public :
    StationSelector (TQWidget *parent);
    ~StationSelector ();

    bool connectI (Interface *i);
    bool disconnectI (Interface *i);

// IStationSelectionClient

    bool noticeStationSelectionChanged(const TQStringList &sl);

// IRadioClient

    bool noticePowerChanged(bool /*on*/)                          { return false; }
    bool noticeStationChanged (const RadioStation &, int /*idx*/) { return false; }
    bool noticeStationsChanged(const StationList &sl);
    bool noticePresetFileChanged(const TQString &/*f*/)            { return false; }

    bool noticeCurrentSoundStreamIDChanged(SoundStreamID)         { return false; }

    void   saveState    (KConfig *) const;
    void   restoreState (KConfig *);
    
    bool   isDirty () const { return m_dirty; }

protected slots:

    void slotButtonToLeft();
    void slotButtonToRight();
    void slotMoveToRight(const TQStringList &list);
    void slotMoveToLeft(const TQStringList &list);

    void slotOK();
    void slotCancel();
    void slotSetDirty();

signals:

    void sigDirty();

protected:

    void moveItem (RadioStationListView *fromListView,    TQStringList          &fromIDList,
                   TQListViewItem        *item,            int                   fromIdx,
                   RadioStationListView *toListView,      TQStringList          &toIDList);

    void updateListViews();

    // station ids
    TQStringList   m_stationIDsAvailable,
                  m_stationIDsSelected,
                  m_stationIDsNotDisplayed,
                  m_stationIDsAll;

    bool          m_dirty;
};

#endif
