/***************************************************************************
                          radioview_volume.cpp  -  description
                             -------------------
    begin                : Don Jun 19 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <tqslider.h>
#include <tqlayout.h>
#include <tqaccel.h>
#include <tqtooltip.h>

#include <klocale.h>

#include "radioview_volume.h"
#include "../../src/include/plugins.h"

#define SLIDER_MINVAL   0
#define SLIDER_MAXVAL   32768
#define SLIDER_RANGE    (SLIDER_MAXVAL - SLIDER_MINVAL)

RadioViewVolume::RadioViewVolume(TQWidget *parent, const TQString &name)
  : RadioViewElement (parent, name, clsRadioSound),
    m_slider(NULL),
    m_handlingSlot(false)
{
    float v = 0;
    SoundStreamID ssid = queryCurrentSoundStreamID();
    sendLogDebug (TQString ("RadioViewVolume: ssid=%1").arg(ssid.getID()));
    queryPlaybackVolume(ssid, v);
    m_slider = new TQSlider(SLIDER_MINVAL,
                           SLIDER_MAXVAL,
                           SLIDER_RANGE/10,
                           getSlider4Volume(v),
                           Qt::Vertical, this);

    TQObject::connect(m_slider, TQT_SIGNAL(valueChanged(int)),
                     this,     TQT_SLOT(slotVolumeChanged(int)));

    TQBoxLayout *l = new TQBoxLayout(this, TQBoxLayout::LeftToRight);
    l->addWidget(m_slider);

    // Tooltips

    TQToolTip::add(m_slider, i18n("Change Volume"));

    // Accelerators
    TQAccel *Accel = new TQAccel (this);
    Accel->insertItem (Key_Up,  100);
    Accel->insertItem (Key_Down, 101);
    Accel->connectItem (100, m_slider, TQT_SLOT(subtractStep()));
    Accel->connectItem (101, m_slider, TQT_SLOT(addStep()));

}


RadioViewVolume::~RadioViewVolume()
{
}


float RadioViewVolume::getUsability (Interface */*i*/) const
{
    return 0.5;  // there could be more features like mute control, capture settings, ...
}


bool RadioViewVolume::connectI   (Interface *i)
{
    bool a = IRadioDeviceClient::connectI(i);
    bool b = ISoundStreamClient::connectI(i);
    return a || b;
}


bool RadioViewVolume::disconnectI(Interface *i)
{
    bool a = IRadioDeviceClient::disconnectI(i);
    bool b = ISoundStreamClient::disconnectI(i);
    return a || b;
}

void RadioViewVolume::noticeConnectedI (ISoundStreamServer *s, bool pointer_valid)
{
    ISoundStreamClient::noticeConnectedI(s, pointer_valid);
    if (s && pointer_valid) {
        s->register4_notifyPlaybackVolumeChanged(this);
    }
}

// ISoundStreamClient

bool RadioViewVolume::noticePlaybackVolumeChanged(SoundStreamID id, float v)
{
    if (queryCurrentSoundStreamID() != id)
        return false;
    m_slider->setValue(getSlider4Volume(v));
    return true;
}



void RadioViewVolume::slotVolumeChanged(int val)
{
    if (m_handlingSlot) return;
    m_handlingSlot = true;
    SoundStreamID ssid = queryCurrentSoundStreamID();
    sendPlaybackVolume(ssid, getVolume4Slider(val));
    m_handlingSlot = false;
}


int RadioViewVolume::getSlider4Volume(float volume)
{
    if (volume >= 1) volume = 1;
    if (volume < 0) volume = 0;
    return SLIDER_MAXVAL - (int)rint(SLIDER_RANGE * volume);
}


float RadioViewVolume::getVolume4Slider(int sl)
{
    if (sl > SLIDER_MAXVAL) sl = SLIDER_MAXVAL;
    if (sl < SLIDER_MINVAL) sl = SLIDER_MINVAL;
    return (float)(SLIDER_MAXVAL - sl) / (float)SLIDER_RANGE;
}



#include "radioview_volume.moc"
