#ifndef LISTCAT_H
#define LISTCAT_H
/* listCat.h			KPilot
**
** Copyright (C) 2000-2001 by Adriaan de Groot
** Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>
**
*/

/** @file
** This is a specialization of KListView to allow the user to
** DnD a fixed set of objects into a fixed set of categories
** (categories set at construction time). @em Deprecated, do not use.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-pim@kde.org
*/

#include <klistview.h>
class TQStringList;

/**
 * This Widget extends KListView for a particular purpose:
 * sorting some items into some bins. This can be useful
 * for putting items in an enabled / disabled state, or
 * into categories, or configuring toolbars (putting
 * icons onto toolbars).
 *
 * You can use all of the standard KListView signals and
 * slots. You may in particular want to change the names
 * of the columns, for example:
 * @code
 * ListCategorizer *lc = new ListCategorizer(this,colors);
 * lc->setColumnText(0,i18n("Color"));
 * lc->setColumnText(1,i18n("HTML"));
 * TQListViewItem *stdKDE = lc->addCategory(i18n("Standard KDE"));
 * (void) new TQListViewItem(stdKDE,i18n("red"),"#FF0000");
 * @endcode
 * to set sensible column headers for a list of colors
 * and their HTML equivalents (although why you would want
 * to categorize colors is beyond me).
 *
 * @version $Id$
 */

class ListCategorizer : public KListView
{
	Q_OBJECT
  TQ_OBJECT

public:
	/**
	 * Constructor.
	 *
	 * This creates a new empty ListCategorizer with
	 * startOpen set to false. The parameters
	 * @p parent and @p name are the usual TQt ones.
	 */
	ListCategorizer(TQWidget *parent,
		const char *name = 0);
	/**
	 * Constructor.
	 *
	 * This creates a ListCategorizer with the given @p categories
	 * already inserted. In addition, this constructor lets you
	 * specify whether or not startOpen is set.
	 */
	ListCategorizer(const TQStringList& categories,
		bool startOpen,
		TQWidget *parent,
		const char *name = 0);

	/**
	 * Add a list of categories to the ListCategorizer.
	 * All the categories are added without descriptions;
	 * use addCategory on a per-category basis for that.
	 */
	void addCategories(const TQStringList&);
	/**
	 * Add a category with name @p name and optional
	 * @p description. This can be useful if you want
	 * either a description for the category or want to
	 * refer to this category in the future without
	 * using findCategory().
	 *
	 * @return the TQListViewItem created for the category
	 */
	TQListViewItem *addCategory(const TQString& name,
		const TQString& description = TQString());
	/**
	 * Returns the list of names of the categories in
	 * the ListCategorizer.
	 */
	TQStringList categories() const
	{
		return listSiblings(firstChild());
	} ;

	/**
	 * Add a single item to the category named @p category,
	 * with name @p name and description set to @p description.
	 * This might be a convenience function, but it's probably
	 * more convenient to just use TQListViewItem's
	 * constructor. That way you can also hide more data in
	 * the remaining columns.
	 */
	TQListViewItem *addItem(const TQString& category,
		const TQString& name,
		const TQString& description = TQString());
	/**
	 * Returns the list of strings in column @p column under
	 * category @p category. You can do this to get, for example
	 * the names of all the items categorized under a given
	 * category, or, more usefully, set @p column to something
	 * other that 0 (name) or 1 (description) to return the
	 * TQStringList hidden in the non-visible columns.
	 */
	TQStringList items(const TQString& category,int column=0) const
	{
		return listSiblings(findCategory(category),column);
	}

	/**
	 * Given a category categoryName return the TQListViewItem
	 * that represents that category. Probably a useless function,
	 * since just remembering the pointer addCategory gives
	 * you is faster and uses hardly any memory.
	 */
	TQListViewItem *findCategory(const TQString& categoryName) const;
	/**
	 * Return the list of strings in column @p column of all siblings
	 * of the given item @p p. If you remembered a pointer to a
	 * category, you can use
	 * @code
	 * TQStringList l = lc->listSiblings(stdKDE->firstChild(),2);
	 * @endcode
	 * to get the list of strings in hidden column 2 under
	 * the category you remembered.
	 */
	TQStringList listSiblings(const TQListViewItem *p,int column=0) const;

	/**
	 * @return whether new categories are inserted in an
	 * open state or not.
	 *
	 * @see setStartOpen
	 */
	bool startOpen() const { return fStartOpen; } ;
	/**
	 * Enable categories being inserted in an open state.
	 * It is disabled by default but may be set from the
	 * constructor.
	 */
	void setStartOpen(bool b) { fStartOpen=b; } ;

protected:
	/**
	 * Reimplemented to prevent categories from being dragged.
	 */
	virtual bool acceptDrag (TQDropEvent* event) const;
	/**
	 * Reimplemented to prevent categories from being dragged.
	 */
	virtual void startDrag();
	/**
	 * Reimplemented to prevent categories from being dragged.
	 */
	virtual void contentsDropEvent (TQDropEvent*);



private:
	/**
	 * Call several KListView functions to set up useful
	 * behavior for this particular class.
	 */
	void setupWidget();

	bool fStartOpen:1;
} ;


class RichListViewItem : public TQListViewItem
{
public:
	RichListViewItem(TQListViewItem *parent,
		TQString,
		int);
	virtual ~RichListViewItem();

	virtual void paintCell(TQPainter *,
		const TQColorGroup &,
		int column,
		int width,
		int alignment);

	virtual void setup();

	bool isRich(int c) const { return fIsRich[c]; } ;
	void setRich(int c,bool b) { fIsRich[c]=b; } ;

protected:
	void computeHeight(int c);

protected:
	bool *fIsRich;
	TQRect *fRect;
	int fColumns;

} ;

#endif
