#ifndef KPROCESSORVIEW_H
#define KPROCESSORVIEW_H


#include <ktoolbar.h>
#include <knuminput.h>
#include <tqcheckbox.h>
#include <klistview.h>

class MyListView : public KListView
{
	Q_OBJECT
  TQ_OBJECT
	public:
		MyListView(TQWidget *parent) ;
		~MyListView() ;

	protected:
//		virtual void mousePressEvent( TQMouseEvent *event ) ;


	public slots:
		void slotContextMenu( KListView *, TQListViewItem *, const TQPoint & ) ;

	signals:
		void showPopupMenu() ;
} ;


class KProcessorView : public KToolBar
{
	Q_OBJECT
  TQ_OBJECT
	public:
    	KProcessorView(TQWidget *parent = 0, const char *name = 0);
    	~KProcessorView();
	
		void setRegisterValues( unsigned char *values ) ;
		void getRegisterValues( unsigned char *values ) ;
		
		void setFlags( unsigned char flags ); 
		unsigned char getFlags() ;
	
	public slots:
		void slotItemRenamed( TQListViewItem * item ) ;
		void slotHexMode() ;
		void showPopupMenu() ;

	signals:
		void processorRegsChanged() ;
		void processorFlagsChanged() ;

	private:
		virtual void resizeEvent( TQResizeEvent *event ) ;
	
	protected:
		MyListView	*view ;
		TQListViewItem	* regs[ 16 ] ;
		TQListViewItem	* zeroFlag, * carryFlag, * ieFlag ;
		bool m_bHexMode ;
};

#endif
