/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  shows all URLs found by the client
  begin:     Die Mai 27 2003
  copyright: (C) 2003 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#ifndef URLCATCHER_H
#define URLCATCHER_H

#include "chatwindow.h"


class KListView;
class TQListViewItem;
class TQPushButton;
class ViewContainer;
class KListViewSearchLineWidget;

class UrlCatcher : public ChatWindow
{
    Q_OBJECT
  TQ_OBJECT

        public:
        explicit UrlCatcher(TQWidget* parent);
        ~UrlCatcher();

        virtual bool canBeFrontView()   { return true; }

        signals:
        void deleteUrl(const TQString& who,const TQString& url);
        void clearUrlList();

    public slots:
        void addUrl(const TQString& who,const TQString& url);

    protected slots:
        void urlSelected();
        void openUrl(TQListViewItem* item);

        void openUrlClicked();
        void copyUrlClicked();
        void deleteUrlClicked();
        void saveListClicked();
        void clearListClicked();

    protected:
        KListView* urlListView;
        KListViewSearchLineWidget* searchWidget;

        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();
        TQPushButton* openUrlButton;
        TQPushButton* copyUrlButton;
        TQPushButton* deleteUrlButton;
        TQPushButton* saveListButton;
        TQPushButton* clearListButton;
};
#endif
