/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  This class holds the various user identities
  begin: Son Feb 9 2003
  copyright: (C) 2003 by Dario Abatianni
  email: eisfuchs@tigress.com
*/

#include "identity.h"
#include "irccharsets.h"

#include <tqtextcodec.h>

#include <kdebug.h>
#include <kglobal.h>


int Identity::s_availableId = 0;

Identity::Identity() : KShared()
{
    m_id = s_availableId;
    s_availableId++;

    init();
}

Identity::Identity(int id) : KShared()
{
    if (id < 0)
    {
        m_id = s_availableId;
        s_availableId++;
    }
    else
    {
        m_id = id;
    }

    init();
}

Identity::Identity(const Identity& original) : KShared()
{
    copy(original);
    m_id = original.id();
}

Identity::~Identity()
{
}

void Identity::init()
{
    setCodecName(Konversation::IRCCharsets::self()->encodingForLocale());

    setInsertRememberLineOnAway(false);

    setQuitReason("Konversation terminated!");
    setPartReason("Konversation terminated!");
    setKickReason("User terminated!");

    setShowAwayMessage(false);
    setAwayMessage("/me is away: %s");
    setReturnMessage("/me is back.");

    setAutomaticAway(false);
    setAwayInactivity(10);
    setAutomaticUnaway(false);
}

void Identity::copy(const Identity& original)
{
    setName(original.getName());
    setRealName(original.getRealName());
    setIdent(original.getIdent());
    setNicknameList(original.getNicknameList());
    setBot(original.getBot());
    setPassword(original.getPassword());
    setQuitReason(original.getQuitReason());
    setPartReason(original.getPartReason());
    setKickReason(original.getKickReason());
    setInsertRememberLineOnAway(original.getInsertRememberLineOnAway());
    setShowAwayMessage(original.getShowAwayMessage());
    setAwayMessage(original.getAwayMessage());
    setAwayNick(original.getAwayNick());
    setReturnMessage(original.getReturnMessage());
    setAutomaticAway(original.getAutomaticAway());
    setAwayInactivity(original.getAwayInactivity());
    setAutomaticUnaway(original.getAutomaticUnaway());
    setShellCommand(original.getShellCommand());
    setCodecName(original.getCodecName());
}

void Identity::setName(const TQString& newName)          { name=newName; }
TQString Identity::getName() const                       { return name; }

void Identity::setRealName(const TQString& name)         { realName=name; }
TQString Identity::getRealName() const                   { return realName; }
void Identity::setIdent(const TQString& newIdent)        { ident=newIdent; }
TQString Identity::getIdent() const                      { return ident; }

void Identity::setNickname(uint index,const TQString& newName) { nicknameList[index]=newName; }

TQString Identity::getNickname(uint index) const 
{
  if(index < nicknameList.count())
    return nicknameList[index];
  else
    return TQString();
}

void Identity::setBot(const TQString& newBot)            { bot=newBot; }
TQString Identity::getBot() const                        { return bot; }

void Identity::setPassword(const TQString& newPassword)  { password=newPassword; }
TQString Identity::getPassword() const                   { return password; }

void Identity::setQuitReason(const TQString& reason)     { quitReason=reason; }
TQString Identity::getQuitReason() const                 { return quitReason; }
void Identity::setPartReason(const TQString& reason)     { partReason=reason; }
TQString Identity::getPartReason() const                 { return partReason; }
void Identity::setKickReason(const TQString& reason)     { kickReason=reason; }
TQString Identity::getKickReason() const                 { return kickReason; }

void Identity::setInsertRememberLineOnAway(bool state) { insertRememberLineOnAway = state; }
bool Identity::getInsertRememberLineOnAway() const { return insertRememberLineOnAway; }
void Identity::setShowAwayMessage(bool state)           { showAwayMessages=state; }
bool Identity::getShowAwayMessage() const               { return showAwayMessages; }

void Identity::setAwayMessage(const TQString& message)   { awayMessage=message; }
TQString Identity::getAwayMessage() const                { return awayMessage; }
void Identity::setReturnMessage(const TQString& message) { returnMessage=message; }
TQString Identity::getReturnMessage() const              { return returnMessage; }

void Identity::setAutomaticAway(bool automaticAway)     { m_automaticAway = automaticAway; }
bool Identity::getAutomaticAway() const                 { return m_automaticAway; }
void Identity::setAwayInactivity(int awayInactivity)   { m_awayInactivity = awayInactivity; }
int Identity::getAwayInactivity() const                { return m_awayInactivity; }
void Identity::setAutomaticUnaway(bool automaticUnaway) { m_automaticUnaway = automaticUnaway; }
bool Identity::getAutomaticUnaway() const               { return m_automaticUnaway; }

void Identity::setNicknameList(const TQStringList& newList)
{
    nicknameList.clear();
    nicknameList = newList;
}

TQStringList Identity::getNicknameList() const           { return nicknameList; }

TQString Identity::getShellCommand() const { return m_shellCommand;}
void Identity::setShellCommand(const TQString& command) { m_shellCommand=command;}

TQTextCodec* Identity::getCodec() const                  { return m_codec; }
TQString Identity::getCodecName() const                  { return m_codecName; }
void Identity::setCodecName(const TQString &newCodecName)
{
    // NOTE: codecName should be based on KCharsets::availableEncodingNames() / descriptiveEncodingNames()
    // We can get a TQTextCodec from TQString based on them, but can't do the reverse of that.

    // never set an empty or borked codec!
    TQString codecName=newCodecName.lower();
    if(!Konversation::IRCCharsets::self()->isValidEncoding(codecName))
        codecName=Konversation::IRCCharsets::self()->encodingForLocale();

    m_codecName=codecName;
    m_codec=Konversation::IRCCharsets::self()->codecForName(codecName);
}

TQString Identity::getAwayNick() const { return awayNick; }
void Identity::setAwayNick(const TQString& n) { awayNick = n; }
