/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>
   Copyright (C) 2006 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPROPERTY_BOOLEDIT_H
#define KPROPERTY_BOOLEDIT_H

#include "../widget.h"
#include "combobox.h"
#include <tqpixmap.h>

class TQToolButton;

namespace KoProperty {

class KOPROPERTY_EXPORT BoolEdit : public Widget
{
	Q_OBJECT
  TQ_OBJECT

	public:
		BoolEdit(Property *property, TQWidget *parent=0, const char *name=0);
		virtual ~BoolEdit();

		virtual TQVariant value() const;
		virtual void setValue(const TQVariant &value, bool emitChange=true);
		virtual void drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value);

	protected slots:
		void  slotValueChanged(int state);

	protected:
		virtual void setReadOnlyInternal(bool readOnly);
		void setState(int state);
		virtual void resizeEvent(TQResizeEvent *ev);
		virtual bool eventFilter(TQObject* watched, TQEvent* e);

	private:
		TQToolButton *m_toggle;
		TQPixmap m_yesIcon, m_noIcon; //!< icons for m_toggle
};

class KOPROPERTY_EXPORT ThreeStateBoolEdit : public ComboBox
{
	Q_OBJECT
  TQ_OBJECT

	public:
		ThreeStateBoolEdit(Property *property, TQWidget *parent=0, const char *name=0);
		virtual ~ThreeStateBoolEdit();

		virtual TQVariant value() const;
		virtual void setValue(const TQVariant &value, bool emitChange=true);

		virtual void setProperty(Property *property);
		virtual void drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value);
		TQPixmap m_yesIcon, m_noIcon; //!< icons for m_toggle
};

}

#endif
