/* This file is part of the KDE project
  Copyright (c) 1999 Matthias Elter (me@kde.org)
  Copyright (c) 2001-2002 Igor Jansen (rm@kde.org)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __ko_ColorChooser_h__
#define __ko_ColorChooser_h__

#include <tqwidget.h>
#include "koColor.h"

class KoFrameButton;
class TQGridLayout;
class TQTabWidget;
class RGBWidget;
class HSVWidget;
class CMYKWidget;
class LABWidget;
class GreyWidget;
class KoColor;
class KoColorSlider;
class TQLabel;
class TQSpinBox;
class KHSSelector;
class KColorPatch;
class ColorWidget;

class KoColorChooser : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  KoColorChooser(TQWidget *parent = 0L, const char *name = 0L);

  const KoColor &color() const {return mColor; }

public slots:
  void slotChangeColor(const KoColor &c);
  void slotChangeColor(const TQColor &c);

signals:
  void colorChanged(const KoColor &c);

protected slots:
  void slotChangeXY(int h, int s);

private slots:
  void childColorChanged(const KoColor& c);
  void slotCurrentChanged(TQWidget *current);

private:
  ColorWidget *m_current;
  KoColor           mColor;
  TQTabWidget *m_tab;
  TQGridLayout      *mGrid;
  KoFrameButton    *btnRGB;
  KoFrameButton    *btnHSV;
  KoFrameButton    *btnCMYK;
  KoFrameButton    *btnLAB;
  KoFrameButton    *btnGrey;
  RGBWidget        *mRGBWidget;
  HSVWidget        *mHSVWidget;
  TQWidget       *mCMYKWidget;
  LABWidget        *mLABWidget;
  GreyWidget       *mGreyWidget;
  KHSSelector      *mColorSelector;
};

class ColorWidget : public TQWidget {
	Q_OBJECT
  TQ_OBJECT

public:
	ColorWidget(TQWidget *parent = 0);
	virtual ~ColorWidget();

public slots:
	virtual void slotChangeColor(const KoColor& c);
	virtual void slotChangeColor(const TQColor& c);
	virtual void slotRefreshColor() = 0;

protected:
	KoColor mColor;
};

class RGBWidget : public ColorWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  RGBWidget(TQWidget *parent = 0L);
  virtual ~RGBWidget() {}

public slots:
  virtual void slotRefreshColor();

protected slots:
  void slotRSliderChanged(int r);
  void slotGSliderChanged(int g);
  void slotBSliderChanged(int b);

  void slotRInChanged(int r);
  void slotGInChanged(int g);
  void slotBInChanged(int b);

  void slotPatchChanged(const TQColor& clr);

signals:
  void colorChanged(const KoColor &c);

private:
  KoColorSlider *mRSlider;
  KoColorSlider *mGSlider;
  KoColorSlider *mBSlider;
  TQLabel *mRLabel;
  TQLabel *mGLabel;
  TQLabel *mBLabel;
  TQSpinBox *mRIn;
  TQSpinBox *mGIn;
  TQSpinBox *mBIn;
  KColorPatch *mColorPatch;
};

class HSVWidget : public ColorWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  HSVWidget(TQWidget *parent = 0L);
  virtual ~HSVWidget() {}

public slots:
  virtual void slotRefreshColor();

protected slots:
  void slotHSliderChanged(int h);
  void slotSSliderChanged(int s);
  void slotVSliderChanged(int v);

  void slotHInChanged(int h);
  void slotSInChanged(int s);
  void slotVInChanged(int v);

  void slotPatchChanged(const TQColor& clr);

signals:
  void colorChanged(const KoColor &c);

private:
  KoColorSlider    *mHSlider;
  KoColorSlider    *mSSlider;
  KoColorSlider    *mVSlider;
  TQLabel           *mHLabel;
  TQLabel           *mSLabel;
  TQLabel           *mVLabel;
  TQSpinBox         *mHIn;
  TQSpinBox         *mSIn;
  TQSpinBox         *mVIn;
  KColorPatch *mColorPatch;
};

class GreyWidget : public ColorWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  GreyWidget(TQWidget *parent = 0L);
  virtual ~GreyWidget() {}

public slots:
  virtual void slotRefreshColor();

protected slots:
  void slotVSliderChanged(int v);
  void slotVInChanged(int v);
  void slotPatchChanged(const TQColor& clr);

signals:
  void colorChanged(const KoColor &c);

protected:
  KoColorSlider *mVSlider;
  TQLabel      *mVLabel;
  TQSpinBox    *mVIn;
  KColorPatch *mColorPatch;
};

class LABWidget : public ColorWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  LABWidget(TQWidget *parent = 0L);
  virtual ~LABWidget() {}

public slots:
  virtual void slotRefreshColor();

protected slots:
  void slotLSliderChanged(int l);
  void slotASliderChanged(int a);
  void slotBSliderChanged(int b);

  void slotLInChanged(int l);
  void slotAInChanged(int a);
  void slotBInChanged(int b);

  void slotPatchChanged(const TQColor& clr);

signals:
  void colorChanged(const KoColor &c);

private:
  KoColorSlider *mLSlider;
  KoColorSlider *mASlider;
  KoColorSlider *mBSlider;
  TQLabel *mLLabel;
  TQLabel *mALabel;
  TQLabel *mBLabel;
  TQSpinBox *mLIn;
  TQSpinBox *mAIn;
  TQSpinBox *mBIn;
  KColorPatch *mColorPatch;
};

#endif

