/* This file is part of the KDE project
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KWQtSqlSerialDataSourceBase.h"
#include "KWQtSqlSerialDataSourceBase.moc"
#include "KWQtSqlMailMergeOpen.h"
#include <tqlayout.h>
#include <tqdom.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <tqsqldatabase.h>
#include <tqmessagebox.h>
#include <kpassdlg.h>
#include <tqsqlrecord.h>
#include <tqsqlcursor.h>
#include <tqdatatable.h>
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>




/******************************************************************
 *
 * Class: KWQtSqlSerialDataSourceBase
 *
 ******************************************************************/

int KWQtSqlSerialDataSourceBase::connectionId=0;

KWQtSqlSerialDataSourceBase::KWQtSqlSerialDataSourceBase(KInstance *inst,TQObject *parent)
	: KWMailMergeDataSource(inst,parent)
{
	DataBaseConnection=TQString("KWTQTSQLPOWER")+parent->name()+TQString("--%1").arg(connectionId++);
	port=i18n("default");
}

KWQtSqlSerialDataSourceBase::~KWQtSqlSerialDataSourceBase()
{
	TQSqlDatabase::removeDatabase(DataBaseConnection);
}


bool KWQtSqlSerialDataSourceBase::showConfigDialog(TQWidget *par,int action)
{
   bool ret=false;
   if (action==KWSLOpen)
   {
   	KWQtSqlMailMergeOpen *dia=new KWQtSqlMailMergeOpen(par,this);

	ret=dia->exec();
	if (ret) openDatabase();
	delete dia;
   }
   return ret;
}

bool  KWQtSqlSerialDataSourceBase::openDatabase()
{
	TQCString pwd;
	TQSqlDatabase::removeDatabase(DataBaseConnection);
        database=TQSqlDatabase::addDatabase(driver,DataBaseConnection);
        if (database)
        {
                if (database->lastError().type()!=TQSqlError::None)
                {
			TQMessageBox::critical(0,i18n("Error"),database->lastError().databaseText(),TQMessageBox::Abort,TQMessageBox::NoButton,TQMessageBox::NoButton);
			return false;
                }
                database->setDatabaseName(databasename);
                database->setUserName(username);
                database->setHostName(hostname);
		if ((port!=i18n("default"))&& (!port.isEmpty()))
			database->setPort(port.toInt());

		if (KPasswordDialog::getPassword(pwd, i18n("Please enter the password for the database connection"))
			== KPasswordDialog::Accepted) database->setPassword(pwd);
                if (database->open())
                {
                        return true;
                }
		TQMessageBox::critical(0,i18n("Error"),database->lastError().databaseText(),TQMessageBox::Abort,TQMessageBox::NoButton,TQMessageBox::NoButton);
		return false;
        }
	TQMessageBox::critical(0,i18n("Error"),i18n("Unable to create database object"),TQMessageBox::Abort,TQMessageBox::NoButton,TQMessageBox::NoButton);
        return false;
}
