/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef tabledia_h
#define tabledia_h

#include <kdialogbase.h>
#include <tqptrlist.h>

#include "defs.h"
#include <KoBorder.h>

class KWCanvas;
class KWDocument;
class KWTableTemplateSelector;

class TQGridLayout;
class TQLabel;
class TQListBox;
class TQWidget;
class TQCheckBox;
class TQButtonGroup;
class TQComboBox;
class TQSpinBox;

/******************************************************************/
/* Class: KWTablePreview                                          */
/******************************************************************/

class KWTablePreview : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    KWTablePreview( TQWidget *_parent, int _rows, int _cols )
        : TQWidget( _parent ), rows( _rows ), cols( _cols ) {}

    void setRows( int _rows ) { rows = _rows; repaint( true ); }
    void setCols( int _cols ) { cols = _cols; repaint( true ); }

protected:
    void paintEvent( TQPaintEvent *e );

    int rows, cols;

};

/******************************************************************/
/* Class: KWTableDia                                              */
/******************************************************************/

class KWTableDia : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    typedef int CellSize; // in fact KWTableFrameSet::CellSize, which is an enum
    enum UseMode{ NEW, EDIT };
    KWTableDia( TQWidget *parent, const char *name, UseMode _useMode, KWCanvas *_canvas,
            KWDocument *_doc, int rows, int cols, CellSize wid, CellSize hei, bool floating,
            const TQString & _templateName,  int format);

protected:
    void setupTab1( int rows, int cols, CellSize wid, CellSize hei, bool floating );
    void setupTab2( const TQString &_templateName,  int format);

    TQWidget *tab1;
    TQLabel *lRows, *lCols;
#ifdef ALLOW_NON_INLINE_TABLES
    TQLabel *lWid, *lHei;
    TQComboBox *cHei, *cWid;
    TQCheckBox *cbIsFloating;
#endif
    TQSpinBox *nRows, *nCols;
    KWTablePreview *preview;
    TQCheckBox *cbReapplyTemplate1, *cbReapplyTemplate2;

    TQGridLayout *grid;
    KWTableTemplateSelector *tableTemplateSelector;

    UseMode m_useMode;
    KWCanvas *canvas;
    KWDocument *doc;

    int oldRowCount, oldColCount;
    TQString oldTemplateName;
protected slots:
    void rowsChanged( int );
    void colsChanged( int );
    void slotSetReapply( bool );
    virtual void slotOk();
    void slotInlineTable( bool );
};

#endif


